package ahr.ice;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.math.*;
import ahr.ice.Math.*;
/**
 * MyClass - a class by (your name here)
 */
public class AddEvents
{
	public static void addEvents(final AHRBot r){
		r.addCustomEvent(new Condition("wallclose") { 
			public boolean test() {
				if (r.getX()<=40){return(true);}
				if (r.getX()>=r.getBattleFieldWidth()-40){return(true);}
				if (r.getY()<=40){return(true);}
				if (r.getY()>=r.getBattleFieldHeight()-40){return(true);}
				else{return(false);}
				}
				
		});
			r.addCustomEvent(new Condition("Robot Close") { 
				public boolean test() {
					Enumeration n= r.targets.elements();
					while (n.hasMoreElements()){			
						Enemy enem = (Enemy) n.nextElement();
						Point2D.Double mep = new Point2D.Double(r.getX(),r.getY());	
						
						if (enem.live && mep.distance(enem.x,enem.y)<100) {
							return true;
						}
					}
					return false;	
				}
			});
			r.addCustomEvent(new Condition("Bullet Close") { 
				public boolean test() {
					Iterator i = r.virtualBullets.iterator();
					while(i.hasNext()){
						VirtualBullet vb = (VirtualBullet) i.next();
						if(r.position().distance(vb)<50) 
							if(vb.target.name.equals(r.getName())){
								return true;
						}	
					}
				return(false);	
				}	
			});	
		
	}
}
