package ahr.ice;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.math.*;
import ahr.ice.Math.*;
import ahr.ice.*;
import ahr.ice.VirtualGuns;
import ahr.ice.Gunner.*;
import java.awt.Graphics2D;
import robocode.annotation.*;
/**
 * MyClass - a class by (your name here)
 */
public class VirtualGuns
{
	
	@SafeStatic
	public static AHRBot r;
	public static double lastEnemyVelocity = 0,
						 lateralDirection = 1;
	public static Vector enemyGuns = new Vector();
	public static void owner(AHRBot ar){
		r = ar;
	}
	public static int counter = 0,
				      enemyShootCounter = 0;
	public static void gun(){
			enemyGuns = new Vector();
			enemyGuns.add(new LinearGun());
			enemyGuns.add(new CircularGun());
			enemyGuns.add(new HeadOnGun());
			enemyGuns.add(new InfinityGun());
			enemyGuns.add(new LinearIterativeGun());
		double firepower = r.firepower;
		long bestScore = -1;
		Gun bestGun = null;
		Iterator i = r.guns.iterator();
		while(i.hasNext()){
			Gun gun = (Gun) i.next();
			if(gun.hits > bestScore){
				bestScore = gun.hits;
				bestGun = gun;
				r.bestGun = r.guns.indexOf(bestGun);
			}
		}
		r.bullet = new Color(0,143,255);
		r.setTurnGunRightRadians(math.normalizeRelativeAngle(bestGun.getFiringAngle(r.me, r.target, firepower,r.battlefield) - r.getGunHeadingRadians()));
		counter++;
		Bullet b = r.setFireBullet(firepower);
		Enemy en = r.setupEnemy(r.target.name);
		if(counter%1 == 0 || b != null){
			Enumeration e = r.targets.elements();
			RobotState oT = r.target;
			for(int j = 0;j<5;j++){
					i = r.guns.iterator();
					while(i.hasNext()){
						Gun gun = (Gun) i.next();
						VirtualBullet newVirtualBullet = new VirtualBullet();
						newVirtualBullet.heading = gun.getFiringAngle(r.myState(), r.target, firepower, r.battlefield);
						newVirtualBullet.setLocation(r.position());
						newVirtualBullet.velocity = 20.0 - (3.0 * firepower);	
						newVirtualBullet.gunUsed = gun;
						newVirtualBullet.shooter = "me";
						newVirtualBullet.target = en;
						r.virtualBullets.add(newVirtualBullet);
					}		
			}
		
			/*Enumeration enu = r.targets.elements();
			while(enu.hasMoreElements()){
				ahr.Math.Enemy enem = (ahr.Math.Enemy)enu.nextElement();
				RobotState t = new RobotState();
				t.setLocation(enem.x,enem.y);
				t.heading = enem.heading;
				t.velocity = enem.speed;
				t.name = enem.name;
				i = enemyGuns.iterator();
				while(i.hasNext()){
					Gun gun = (Gun) i.next();
					VirtualBullet nvb = new VirtualBullet();
					nvb.heading = gun.getFiringAngle(t, r.me, 3, r.battlefield);
					nvb.setLocation(r.target);
					nvb.velocity = 20.0 - 3.0 * 3;	
					nvb.gunUsed = gun;
					nvb.shooter = r.target.name;
					ahr.Math.Enemy enm = r.setupEnemy(r.getName());
					enm.coords = r.position();
					enm.name = r.getName();
					nvb.target = enm;
					r.virtualBullets.add(nvb);
				}
			}*/
		}	
	}	
	public static void enemyFire(double power, Enemy enem) {
		enemyShootCounter++;
		if (enemyShootCounter%1==0) {
			RobotState t = new RobotState();
			t.setLocation(enem.x,enem.y);
			t.heading = enem.heading;
			t.velocity = enem.speed;
			t.name = enem.name;
			Iterator i = enemyGuns.iterator();
			while(i.hasNext()){
				Gun gun = (Gun) i.next();
				VirtualBullet newVirtualBullet = new VirtualBullet();
				newVirtualBullet.heading = gun.getFiringAngle(t, r.myState(), power, r.battlefield);
				newVirtualBullet.setLocation(r.target);
				newVirtualBullet.velocity = 20.0 - (3.0 * power);	
				newVirtualBullet.gunUsed = gun;
				newVirtualBullet.shooter = enem.name;
				Enemy enm = r.setupEnemy("me");
				enm.coords = r.position();
				enm.name = "me";
				newVirtualBullet.target = enm;
				r.virtualBullets.add(newVirtualBullet);
			}
		}
	}	
	static boolean b;
	public static void moveBullets(Rectangle2D.Double battlefield){
		int turnDirection =1;	
		Iterator i = r.virtualBullets.iterator();
		while(i.hasNext()){
			VirtualBullet virtualBullet = (VirtualBullet) i.next();
			virtualBullet.setLocation(virtualBullet.x + Math.sin(virtualBullet.heading) * virtualBullet.velocity,
									  virtualBullet.y + Math.cos(virtualBullet.heading) * virtualBullet.velocity);
			Enemy en = virtualBullet.target;
			Point2D.Double t = en.coords;
			if(virtualBullet.distance(t) < 25 && virtualBullet.shooter.equals("me")){				
				virtualBullet.gunUsed.hits += 1;
				i.remove();
			}
			else
			if(!battlefield.contains(virtualBullet)){
				i.remove();
			}
		}
			
	}	

}	


class LinearIterativeGun extends Gun{
	public String getName(){return "LinearIterative Gun";}
	public Color getColor(){return Color.RED;}
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {

	    final double ROBOT_WIDTH = 16,ROBOT_HEIGHT = 16;
	    // Variables prefixed with e- refer to enemy, b- refer to bullet and r- refer to robot
	    final double eAbsBearing = shooter.absoluteAngleTo(target);
	    final double rX = shooter.x, rY = shooter.y,
	        bV = Rules.getBulletSpeed(bulletPower);
	    final double eX = rX + shooter.distance(target)*Math.sin(eAbsBearing),
	        eY = rY + shooter.distance(target)*Math.cos(eAbsBearing),
	        eV = target.velocity,
	        eHd = target.heading;
	    // These constants make calculating the quadratic coefficients below easier
	    final double A = (eX - rX)/bV;
	    final double B = eV/bV*Math.sin(eHd);
	    final double C = (eY - rY)/bV;
	    final double D = eV/bV*Math.cos(eHd);
	    // Quadratic coefficients: a*(1/t)^2 + b*(1/t) + c = 0
	    final double a = A*A + C*C;
	    final double b = 2*(A*B + C*D);
	    final double c = (B*B + D*D - 1);
	    final double discrim = b*b - 4*a*c;
	        // Reciprocal of quadratic formula
	        final double t1 = 2*a/(-b - Math.sqrt(discrim));
	        final double t2 = 2*a/(-b + Math.sqrt(discrim));
	        final double t = Math.min(t1, t2) >= 0 ? Math.min(t1, t2) : Math.max(t1, t2);
	        // Assume enemy stops at walls
	        final double endX = math.limit(
	            eX + eV*t*Math.sin(eHd),
	            ROBOT_WIDTH/2, getBattleFieldWidth(battlefield) - ROBOT_WIDTH/2);
	        final double endY = math.limit(
	            eY + eV*t*Math.cos(eHd),
	            ROBOT_HEIGHT/2, getBattleFieldHeight(battlefield) - ROBOT_HEIGHT/2);
	       return(robocode.util.Utils.normalRelativeAngle(
	            Math.atan2(endX - rX, endY - rY)));
		
	}
}

class LinearGun extends Gun{
	public String getName(){return "Linear";}
	public Color getColor(){return Color.YELLOW;}
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
		Point2D.Double me = new Point2D.Double(shooter.getX(), shooter.getY());
		Point2D.Double enemy = target;
		
		
		double deltaTime = 1;
		double battleFieldHeight = battlefield.getHeight(), battleFieldWidth = battlefield.getWidth();
		
		Point2D.Double predicted = (Point2D.Double) enemy.clone();
		
		while(deltaTime * (20.0 - 3.0 * bulletPower) < me.distance(predicted)){		
			deltaTime++;
			predicted = math.project(predicted, target.heading, target.velocity);
			
			predicted.x = Math.min(Math.max(18.0, predicted.x), battleFieldWidth - 18.0);	
			predicted.y = Math.min(Math.max(18.0, predicted.y), battleFieldHeight - 18.0);
		}
		return(Utils.normalRelativeAngle(math.angle(me, predicted)));
	}
}
class CircularGun extends Gun{
	public String getName(){return "Circular Gun";}
	public Color getColor(){return Color.WHITE;}
	static double oldEnemyHeading = 0;
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
		double myX = shooter.getX();
		double myY = shooter.getY();
		double absoluteBearing = shooter.heading + shooter.absoluteAngleTo(target);
		double enemyX = target.x;
		double enemyY = target.y;
		double enemyHeading = target.heading;
		double enemyHeadingChange = enemyHeading - oldEnemyHeading;
		double enemyVelocity = target.velocity;
		oldEnemyHeading = enemyHeading;
		 
		double deltaTime = 0;
		double battleFieldHeight = battlefield.getHeight(), 
		       battleFieldWidth = battlefield.getWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < 
		      Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			enemyHeading += enemyHeadingChange;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
		 
				predictedX = Math.min(Math.max(18.0, predictedX), 
				    battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), 
				    battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(
		    predictedX - shooter.x, predictedY - shooter.y));
		 
		return(Utils.normalRelativeAngle(
		    theta));
	}
}
class InfinityGun extends Gun{
	public String getName(){return "Infinity";}
	public Color getColor(){return Color.ORANGE;}
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
			double absoluteBearing = shooter.absoluteAngleTo(target);
			return(Math.asin(Math.sin(absoluteBearing + 
				(1-shooter.distance(target)/500) * 
				Math.asin(target.velocity / Rules.getBulletSpeed(bulletPower)) * Math.sin(shooter.heading - absoluteBearing) )));
	

	}
}
class SimpleGun extends Gun {
	public String getName(){return "Simple linear gun";}
	public Color getColor(){return new Color(0,255,255);}
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
		//double maxAngle = Math.asin(8.0 / (20.0 - 3.0 * bulletPower));
		double directAngle = shooter.absoluteAngleTo(target);
		return directAngle - target.velocity * Math.sin(directAngle - target.heading) / (20.0 - 3.0 * bulletPower);
	}
}
class RandomGun extends Gun {
	public String getName(){return "Random gun";}
	public Color getColor(){return new Color(0,255,255);}
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
		//double maxAngle = Math.asin(8.0 / (20.0 - 3.0 * bulletPower));
		double directAngle = shooter.absoluteAngleTo(target);	
	    double maxEscapeAngle = Math.asin(8.0/(20 - (3 * bulletPower)));
		double robotWidthAngle = 36/shooter.distance(target);
		double firingAngle = directAngle + (Math.random()-0.5) * 2 * maxEscapeAngle;
		return firingAngle;
	}
}

class HeadOnGun extends Gun {
	public String getName(){return "Head on";}
	public Color getColor(){return Color.GREEN;}
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
		return shooter.absoluteAngleTo(target);
	}
}

class MeanCircularGun extends Gun {
	public String getName()	{ return "Mean Circuar"; }
	public Color  getColor(){ return new Color(125,0,125); }	
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield){
		Enemy en = VirtualGuns.r.setupEnemy(target.name);
		double myX = shooter.getX();
		double myY = shooter.getY();
		double absoluteBearing = shooter.heading + shooter.absoluteAngleTo(target);
		double enemyX = target.x;
		double enemyY = target.y;
		double enemyHeading = target.heading;
		double enemyHeadingChange = en.meanHeadingChange;
		double enemyVelocity = en.meanVelocity;
		 
		double deltaTime = 0;
		double battleFieldHeight = battlefield.getHeight(), 
		       battleFieldWidth = battlefield.getWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < 
		      Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			enemyHeading += enemyHeadingChange;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
		 
				predictedX = Math.min(Math.max(18.0, predictedX), 
				    battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), 
				    battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(
		    predictedX - shooter.x, predictedY - shooter.y));
		 
		return(Utils.normalRelativeAngle(
		    theta));
	}
}

class MeanIterativeGun extends Gun {
	public String getName()	{ return "Mean Iterative"; }
	public Color  getColor(){ return new Color(250,120,0); }	
	
	public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield){
		Enemy en = VirtualGuns.r.setupEnemy(target.name);
		
	    final double ROBOT_WIDTH = 16,ROBOT_HEIGHT = 16;
	    // Variables prefixed with e- refer to enemy, b- refer to bullet and r- refer to robot
		RobotState eC = new RobotState();
		eC.setLocation(en.coords);
	    final double eAbsBearing = shooter.absoluteAngleTo(eC);
	    final double rX = shooter.x, rY = shooter.y,
	        bV = Rules.getBulletSpeed(bulletPower);
	    final double eX = rX + shooter.distance(en.coords)*Math.sin(eAbsBearing),
	        eY = rY + shooter.distance(en.coords)*Math.cos(eAbsBearing),
	        eV = en.meanVelocity,
	        eHd = en.heading,
			eHc = en.meanHeadingChange;
	
	    // These constants make calculating the quadratic coefficients below easier
	    final double A = (eX - rX)/bV;
	    final double B = eV/bV*Math.sin(eHd);
	    final double C = (eY - rY)/bV;
	    final double D = eV/bV*Math.cos(eHd);
	    // Quadratic coefficients: a*(1/t)^2 + b*(1/t) + c = 0
	    final double a = A*A + C*C;
	    final double b = 2*(A*B + C*D);
	    final double c = (B*B + D*D - 1);
	    final double discrim = b*b - 4*a*c;
	        // Reciprocal of quadratic formula
	        final double t1 = 2*a/(-b - Math.sqrt(discrim));
	        final double t2 = 2*a/(-b + Math.sqrt(discrim));
	        final double t = Math.min(t1, t2) >= 0 ? Math.min(t1, t2) : Math.max(t1, t2);
	        // Assume enemy stops at walls
	        final double endX = math.limit(
	            eX + eV*t*Math.sin(eHd),
	            ROBOT_WIDTH/2, getBattleFieldWidth(battlefield) - ROBOT_WIDTH/2);
	        final double endY = math.limit(
	            eY + eV*t*Math.cos(eHd),
	            ROBOT_HEIGHT/2, getBattleFieldHeight(battlefield) - ROBOT_HEIGHT/2);
	       return(robocode.util.Utils.normalRelativeAngle(
	            Math.atan2(endX - rX, endY - rY)));
	}
}


