package arthord;

import robocode.*;
import robocode.util.Utils;

/*
 * NanoSatan - A bot by Kuuran
 */

public class NanoSatan extends AdvancedRobot
{
	static final int	DEPTH = 30;
	static final int	BVEL = 11;
	static final int	END = 100;
	static int 			index;
	static double 		ev[] = new double[100000];
	static StringBuffer patternMatcher = new StringBuffer();

	public void run()
	{
		setAdjustRadarForGunTurn(true);
		do
		{
			turnRadarRightRadians(1);
		}
		while(true);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		int depth = DEPTH;
		int match;
		double arc, targetBearing;

		setTurnRightRadians(Math.cos(e.getBearingRadians()));

		ev[++index] = ev[index - 1] + (arc = e.getVelocity() * Math.sin(e.getHeadingRadians() - (targetBearing = e.getBearingRadians() + getHeadingRadians())));

		if(getDistanceRemaining() == 0)
		{
			setAhead(600 * Math.random() - 300);
		}

		patternMatcher.append((char)(arc));

		do
		{
			match = patternMatcher.lastIndexOf(patternMatcher.substring(Math.max(index-depth, 0) ), index - END);
		} while (--depth * match < -1);

		match += depth;

		setTurnGunRightRadians(Utils.normalRelativeAngle((ev[match + (int)(e.getDistance()/BVEL)] - ev[match]) / e.getDistance() + targetBearing - getGunHeadingRadians()));

		setFire(3);

		setTurnRadarRightRadians(Utils.normalRelativeAngle(targetBearing - getRadarHeadingRadians()) * 2);
	}
}