package maribo;
import robocode.*;
import robocode.util.*;
import java.awt.Color;

/**
 * FollowFire - a robot by Alexander MacKenzie
 */
public class FollowFire extends AdvancedRobot
{	
	public void run() {
		setColors(Color.red,Color.black,Color.black,Color.black,Color.red);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
		
		while(true) {
			if (getRadarTurnRemaining() == 0) setTurnRadarRight(Double.MAX_VALUE);
            execute();
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double bulletPower = 3;
		if (e.getEnergy() <= 16 && e.getEnergy() > 10 || e.getDistance() > 100) {
			bulletPower = 2;
		} else if (e.getEnergy() > .4) {
			bulletPower = e.getEnergy()/4.1;
		}
    	double headOnBearing;
		double turnAmount = Utils.normalRelativeAngle(
				((headOnBearing = getHeadingRadians() + e.getBearingRadians())
				 + Math.asin(e.getVelocity() / Rules.getBulletSpeed(bulletPower)
				 * Math.sin(e.getHeadingRadians() - headOnBearing)))
				 - getHeadingRadians());
		double radarTurn = headOnBearing - getRadarHeadingRadians();
    	setTurnRightRadians(turnAmount);
		setTurnRadarRightRadians(2*Utils.normalRelativeAngle(radarTurn));
		setAhead(e.getDistance());
		setFire(bulletPower);
	}
}					