package bayen;
import robocode.*;
import robocode.util.*;
import java.awt.geom.*;
public class DuelRobot extends TeamRobot {
	public ScannedRobotEvent e;
	private int corner = 0;
	private double crazyTurnDir = 1;
	private double crazyMoveDir = 1;
	private double buzzDir = 1;
	private static Rectangle2D.Double _fieldRect;
    private static double WALL_STICK = 160;
	public void setFireAtEnemy(double bulletPower) {
		setTurnGunRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getGunHeadingRadians()));
		setFire(bulletPower);
	}
	public void setOrbit(double direction, double distance) {
		double goAngle = e.getBearingRadians() + getHeadingRadians();
		if(direction > 0) {
			goAngle += Math.PI/2 + Math.toRadians(20) * (e.getDistance() < distance?1:-1);
		}
		else {
			goAngle -= Math.PI/2 + Math.toRadians(20) * (e.getDistance() < distance?1:-1);
		}
		setGoDirection(Math.toDegrees(goAngle));
	}
	public void setOrbit(double direction) {
		setOrbit(direction, 300.0);
	}
	public void setOrbit() {
		setOrbit(1.0);
	}
	public void setRam() {
		setGoDirection(e.getBearing() + getHeading());
	}
	public void setWalls() {
		if(getDistanceRemaining() == 0) {
			corner++;
			if(corner > 4) {
				corner = 1;
			}
			if(corner == 1) {
				setGoToPoint(100,100);
			}
			else if(corner == 2) {
				setGoToPoint(getBattleFieldWidth() - 100, 100);
			}
			else if(corner == 3) {
				setGoToPoint(getBattleFieldWidth() - 100, getBattleFieldHeight() - 100);
			}
			else if(corner == 4) {
				setGoToPoint(100, getBattleFieldHeight() - 100);
			}
		}
	}
	public void setTrack() {
		if(e.getDistance() > 100)
		setGoDirection(e.getBearing() + getHeading());
		else
		setGoDirection(e.getBearing() + getHeading() + 180);
	}
	public void setCrazy() {
		if(getTurnRemaining() == 0) {
			setTurnRight(180 * crazyTurnDir);
			crazyTurnDir *= -1;
		}
		setAhead(100 * crazyMoveDir);
	}
	public void setToCorner(int corner) {
		if(corner == 1) {
			setGoToPoint(20,20);
		}
		else if(corner == 2) {
			setGoToPoint(getBattleFieldWidth() - 20, 20);
		}
		else if(corner == 3) {
			setGoToPoint(getBattleFieldWidth() - 20, getBattleFieldHeight() - 20);
		}
		else if(corner == 4) {
			setGoToPoint(20, getBattleFieldHeight() - 20);
		}
		else {
			setGoToPoint(20,20);
		}
	}
	public void setToCorner() {
		setToCorner(1);
	}
	public void setBackAndForth(double distance) {
		if(getDistanceRemaining() == 0) {
			buzzDir *= -1;
			setAhead(distance * buzzDir);
		}
	}
	public void setBackAndForth() {
		setBackAndForth(100);
	}
	public void setTurnPerpendicular() {
		setTurnRight(e.getBearing() + 90);
	}
	public void setSpin() {
		setMaxVelocity(5);
		setTurnRight(360);
		setAhead(100);
	}
	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		_fieldRect = new java.awt.geom.Rectangle2D.Double(18, 18, getBattleFieldWidth() - 18, getBattleFieldHeight() - 18);
		onStartRobot();
		while(true) {
			run(true);
			setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			execute();
		}
	}
	public void onScannedRobot(ScannedRobotEvent scan) {
		e = scan;
		onScannedRobot(scan, true);
		setMaxVelocity(8);
		setTurnRadarRightRadians(Utils.normalRelativeAngle((e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians()) * 2.2));
		onGun();
		onMove();
		execute();
	}
	public void onHitWall(HitWallEvent e) {
		crazyMoveDir *= -1;
		onHitWall(e, true);
	}
	public void onHitRobot(HitRobotEvent e) {
		if(e.isMyFault()) {
			crazyMoveDir *= -1;
		}
		onHitRobot(e, true);
	}
	public void onHitByBullet(HitByBulletEvent e) {
		onHitByBullet(e,true);
	}
	public void onBulletHit(BulletHitEvent e) {
		onBulletHit(e,true);
	}
	public void onBulletMissed(BulletMissedEvent e) {
		onBulletMissed(e,true);
	}
	public void onRobotDeath(RobotDeathEvent e) {
		onRobotDeath(e,true);
	}
	public void onWin(WinEvent e) {
		onWin(e,true);
	}
	public void onDeath(DeathEvent e) {
		onDeath(e,true);
	}
	public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }
	public void setGoDirection(double goAngle) {
        double angle =
            Utils.normalRelativeAngle(Math.toRadians(goAngle) - getHeadingRadians());
		if(angle > 0) angle = wallSmoothing(new Point2D.Double(getX(), getY()), angle, 1);
		if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                setTurnRightRadians(Math.PI + angle);
            } else {
                setTurnLeftRadians(Math.PI - angle);
            }
            setBack(100);
        } else {
            if (angle < 0) {
                setTurnLeftRadians(-1*angle);
           } else {
                setTurnRightRadians(angle);
           }
            setAhead(100);
        }
    }
    public void setGoToPoint(double goX, double goY) {
    	Point2D.Double go = new Point2D.Double(goX, goY);
		double x = getX(), y = getY(), turnAngle;
		double angle = robocode.util.Utils.normalRelativeAngle(Math.atan2(go.x - x, go.y - y) - getHeadingRadians());
		setTurnRightRadians(turnAngle = Math.atan(Math.tan(angle)));
		setAhead((angle == turnAngle) ? Point2D.distance(x, y, go.x, go.y) : -Point2D.distance(x, y, go.x, go.y));
	}
	public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(project(botLocation, angle, 160))) {
            angle += orientation*0.05;
        }
        return angle;
    }
	public void onStartRobot() {
	
	}
	public void onGun() {
		
	}
	public void onMove() {
	
	}
	public void run(boolean duel) {
		
	}
	public void onScannedRobot(ScannedRobotEvent e, boolean duel) {
		
	}
	public void onHitWall(HitWallEvent e, boolean duel) {
		
	}
	public void onHitRobot(HitRobotEvent e, boolean duel) {
		
	}
	public void onHitByBullet(HitByBulletEvent e, boolean duel) {
		
	}
	public void onBulletHit(BulletHitEvent e, boolean duel) {
		
	}
	public void onBulletMissed(BulletMissedEvent e, boolean duel) {
		
	}
	public void onRobotDeath(RobotDeathEvent e, boolean duel) {
		
	}
	public void onWin(WinEvent e, boolean duel) {
		
	}
	public void onDeath(DeathEvent e, boolean duel) {
		
	}
}