// MatchupMini by Stelokim
//
// History
// version 1.0: 20071014. codesize = 1374
// version 1.1: 20071019. codesize = 1277, new movement, more eager to fire

package stelo;

import java.awt.geom.*;

import robocode.*;
import robocode.util.Utils;

public class MatchupMini extends AdvancedRobot {
	private static final int NUM_LOGS = 2; // [0]: velocity, [1]: angleChange, [2]: distance, [3]: bearingChange, [4]: ticksSinceMyFire
	private static final int PATTERN_LENGTH = 9000;
	private static int searchLength = 20; // increasing this will slow down the game. 20
	private static int pattern_size;

	private static double[][] theLog = new double[PATTERN_LENGTH][NUM_LOGS];
	private static int cursor;
	private static double movementLateralAngle = 0.4;
	private static Point2D enemyLocation;
	private static Point2D robotLocation;
	private static double enemyDistance;
	
	private static final double WALL_MARGIN = 25;
	
	private static double lastEnemyHeading;
//	private static double lastEnemyEnergy;
	
	private static double enemyBulletPower = 0.1;
	
	private static int CLOSEST_SIZE = 50;
	private static double MAX_ESCAPE_ANGLE = 0.9;

	private int hitRobotCount = 0;
	private static final int ramThreshold = 0;
	private static double absBearing;

	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		do {
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		} while (true);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		absBearing = e.getBearingRadians() + getHeadingRadians();
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing
				- getRadarHeadingRadians()) * 2); // 2 original

		robotLocation = new Point2D.Double(getX(), getY());
		enemyDistance = e.getDistance();
		enemyLocation = vectorToLocation(absBearing, enemyDistance,
				robotLocation);
		
		{
			theLog[cursor][0] = e.getVelocity();
			theLog[cursor][1] = Utils.normalRelativeAngle(e.getHeadingRadians() - lastEnemyHeading);
			
			cursor = (cursor + 1) % PATTERN_LENGTH;
//			out.println(cursor);
			if (pattern_size < PATTERN_LENGTH)
				pattern_size++;
		}				
				
		
//		double energyDrop = lastEnemyEnergy - e.getEnergy();
//		if (energyDrop >= 0.1 && energyDrop <= 3) {
//			enemyBulletPower = energyDrop;
//		}
		double bulletPower = 1.9;
		if (enemyDistance < 50.0) bulletPower = 3.0;
				
		bulletPower = Math.min(bulletPower, Math.min(getEnergy(), e.getEnergy() / 5.0));
		bulletPower = limit(0.1, bulletPower, 3.0);
				
		if (getGunHeat() / getGunCoolingRate() < 4.0) {			
			setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians() + bestBearing(theLog, e, bulletPower, absBearing)));
			setFire(bulletPower);
		} else {
			setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()));
		}
		randomMove();

		lastEnemyHeading = e.getHeadingRadians();
//		lastEnemyEnergy = e.getEnergy();
	}

	public void onHitRobot(HitRobotEvent e) {
		hitRobotCount++;
		considerRamming();		
	}

	private void considerRamming() {
		if (hitRobotCount > ramThreshold && getOthers() == 1) {
			goTo(enemyLocation);
		}
	}

	public void onSkippedTurn(SkippedTurnEvent e) {
		out.println("SkippedTurn at: " + e.getTime());
	}

	// statistical pattern-matcher
	private double bestBearing(double[][] series, ScannedRobotEvent e, double bulletPower, double absBearing) {
		int[] closestIndexes = new int[CLOSEST_SIZE];
		double[] closestDiffs = new double[CLOSEST_SIZE];
		int count = 0, i, c;
		final double bulletSpeed = (20.0 - 3.0 * bulletPower);
		final double bulletTravelTime = enemyDistance / bulletSpeed;
		
		for (c = 0 ; c < CLOSEST_SIZE; c++) {
			closestDiffs[c] = Double.POSITIVE_INFINITY;
		}
			
		i = (PATTERN_LENGTH + cursor - searchLength - 1) % PATTERN_LENGTH;
		while (count < PATTERN_LENGTH) {
			double diff = 0;
			
			for (int j = 0; j < searchLength; j++) {
				int k = (PATTERN_LENGTH + i - j) % PATTERN_LENGTH;
				int searchIndex = (PATTERN_LENGTH + cursor - j) % PATTERN_LENGTH;
				if (k == searchIndex) {
					diff = Double.POSITIVE_INFINITY;
					//out.println("sdfasf");
					break;
				}
				diff += Math.abs(series[searchIndex][0] - series[k][0]) + // velocity
					Math.abs(series[searchIndex][1] - series[k][1]) * 40.0; // maximum turning, angleChange
			}
		
			// find maximum difference index
			int maxDiffIndex = 0;
			for (c = 0; c < CLOSEST_SIZE; c++) {
				if (closestDiffs[c] > closestDiffs[maxDiffIndex])
					maxDiffIndex = c;
			}
		
			// insert into the maximum difference index
			if (diff < closestDiffs[maxDiffIndex] && Math.abs(i - cursor) > bulletTravelTime) {
				closestDiffs[maxDiffIndex] = diff;
				closestIndexes[maxDiffIndex] = i;
			}		
			count++;
			i = (PATTERN_LENGTH + i - 1) % PATTERN_LENGTH;
		}
	
		double initialEX = enemyDistance * Math.sin(absBearing);
		double initialEY = enemyDistance * Math.cos(absBearing);
		double eV = e.getVelocity();
		
		double angleThreshold = 36.0 / e.getDistance();
		int binSize = (int) (MAX_ESCAPE_ANGLE * 2.0 / angleThreshold) + 1;
		int[] statBin = new int[binSize];
		double[] metaAngle = new double[binSize];
		int maxIndex = 0;		
	
		// reconstruct enemy movement and find the most popular angle
		for (c = 0 ; c < CLOSEST_SIZE; c++) {
			double eX = initialEX;
			double eY = initialEY;
			double ww = e.getHeadingRadians();
			double v = eV;
			double db = 0;
			int index = closestIndexes[c];
	
			do {
				db += bulletSpeed;

				eX += v * Math.sin(ww);
				eY += v * Math.cos(ww);

				ww += theLog[index][1];
				v = theLog[index][0];
				
				if (index + 1 != cursor) {
					index = (index + 1) % PATTERN_LENGTH;
				}
			} while (db < Point2D.distance(0, 0, eX, eY));
		
			if (fieldRectangle(17).contains(new Point2D.Double(eX + robotLocation.getX(), eY + robotLocation.getY()))) {
				double angle = Utils.normalRelativeAngle(Math.atan2(eX, eY) - absBearing);
				
				int binIndex = (int) ((angle + MAX_ESCAPE_ANGLE) / angleThreshold);
				metaAngle[binIndex] = angle;				
				statBin[binIndex]++;
				if (statBin[binIndex] > statBin[maxIndex]) {
					maxIndex = binIndex;
				}
			}

			//angles[c] = Utils.normalRelativeAngle(Math.atan2(eX, eY) - absBearing);
			//angles[c] = Utils.normalRelativeAngle(Math.atan2(limit(18, eX + robotLocation.getX(), maxX) - robotLocation.getX(), limit(18, eY + robotLocation.getY(), maxY) - robotLocation.getY()) - absBearing);
		}
	
		return metaAngle[maxIndex];
	}							
	
	private static final double REVERSE_TUNER = 0.421075;
//	private static final double WALL_BOUNCE_TUNER = 0.699484;	
/*	private void randomMove() {
		Point2D robotDestination;
		double tries = 0;
		do {
			robotDestination = vectorToLocation(absoluteBearing(enemyLocation,
					robotLocation)
					+ movementLateralAngle, enemyDistance * (1.2 - tries / 100.0), enemyLocation); // 1.1
			tries++;
		} while (tries < 125
				&& !fieldRectangle(WALL_MARGIN).contains(robotDestination));
				
		double bv = 20.0 - 3.0 * enemyBulletPower;
		double ed = enemyDistance;
		if (ed < 150) ed = 150;
		if (Math.random() < (bv / REVERSE_TUNER) / ed || tries > (ed / bv / WALL_BOUNCE_TUNER)) {
			movementLateralAngle = -movementLateralAngle;	
		}									

		// } while (tries < 100 &&
		// !fieldRectangle(WALL_MARGIN).contains(robotDestination));

		goTo(robotDestination);
		considerRamming();
	}
*/
	private static double direction = 1.0;
	private void randomMove() {
		Point2D robotDestination;
		double angle = Math.PI / 2.0 + 0.2;
		
		do {
			robotDestination = vectorToLocation(absBearing + direction * angle, 100.0, robotLocation);
			angle -= 0.05;
		} while (!fieldRectangle(WALL_MARGIN).contains(robotDestination));
	
		double bv = 20.0 - 3.0 * enemyBulletPower;
		if (Math.random() < (bv / REVERSE_TUNER) / (enemyDistance + 100.0)) {
			direction = -direction;
		}

		goTo(robotDestination);
		considerRamming();
	}													

	private RoundRectangle2D fieldRectangle(double margin) { 
		return new RoundRectangle2D.Double(margin, margin, getBattleFieldWidth() - margin *
		 2, getBattleFieldHeight() - margin * 2, 75, 75); // 75
	}

//	private Rectangle2D fieldRectangle(double margin) {
//		return new Rectangle2D.Double(margin, margin, getBattleFieldWidth()
//				- margin * 2, getBattleFieldHeight() - margin * 2);
//	}

	private void goTo(Point2D destination) {
		double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation,
				destination)
				- getHeadingRadians());
		double turnAngle = Math.atan(Math.tan(angle));
		
		setTurnRightRadians(turnAngle);
		setAhead(robotLocation.distance(destination)
				* (angle == turnAngle ? 1 : -1));
		// Hit the brake pedal hard if we need to turn sharply
		setMaxVelocity(Math.abs(getTurnRemaining()) > 30 ? 0 : 8);
		//setMaxVelocity(8.0 * (1.0 - Math.abs(getTurnRemaining()) / 30.0));

		// vibrate
//		if (Math.abs(getTurnRemaining()) < 1) {
//			setTurnRight(Math.random() < 0.5 ? 10 : -10);
//		}
	}

	private static Point2D vectorToLocation(double angle, double length,
			Point2D sourceLocation) {
		return vectorToLocation(angle, length, sourceLocation,
				new Point2D.Double());
	}

	private static Point2D vectorToLocation(double angle, double length,
			Point2D sourceLocation, Point2D targetLocation) {
		targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle)
				* length, sourceLocation.getY() + Math.cos(angle) * length);
		return targetLocation;
	}

	private static double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY()
				- source.getY());
	}

	public static double limit(double min, double value, double max) {
		return Math.max(min, Math.min(value, max));
	}
}
