/*
 * BotMath - utility class for Robocode robots.
 * Copyright (C) 2002  Joachim Hofer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * You can contact the author via email (qohnil@johoop.de) or write to
 * Joachim Hofer, Feldstr. 12, D-91052 Erlangen, Germany.
 */

package qohnil.util;

import java.util.Random;
import java.awt.geom.Point2D;

public class BotMath {
	private BotMath() {}

    public static final double DEGREES = 180.0 / Math.PI;
	public static final double PI2 = 2.0 * Math.PI;
    public static final double DEG90 = Math.PI / 2.0;
    public static final Random random = new Random();

	public static double normalizeRelativeAngle(double angle) {

    	double mod = angle % (PI2);

        if (mod <= (-Math.PI)) {
        	return Math.PI + (mod % Math.PI);
    	} else if (mod > Math.PI) {
    		return (-Math.PI) + (mod % Math.PI);
    	} else {
    		return mod;
    	}
    } 

	public static double normalizeAbsoluteAngle(double angle) {
        if (angle < 0) {
        	return PI2 + (angle % PI2);
    	} else if (angle >= PI2) {
    		return angle % PI2;
    	} else {
    		return angle;
    	}
	}

    public static boolean nextRandomBoolean(double threshold) {
        return random.nextDouble() < threshold;
    }

    public static Coords polarToCoords(double bearing, double distance,
                                Coords origin) {
        double x = origin.getX() + distance * Math.sin(bearing);
        double y = origin.getY() + distance * Math.cos(bearing);

        return new Coords(x, y);
    }

    public static Polar coordsToPolar(Coords object, Coords origin) {
        double distance = object.distance(origin);
        if (distance == 0.0) {
            return new Polar(0.0, 0.0);
        }
        double dx = object.getX() - origin.getX();
        double dy = object.getY() - origin.getY();
        double bearing = Math.acos(dy / distance);
        if (dx < 0) {
            bearing = BotMath.PI2 - bearing;
        }

        return new Polar(bearing, distance);
    }

    public static double getShotVelocity(double firePower) {
        return 20 - (3 * Math.min(3.0, Math.max(0.1, firePower)));
    }

    public static double getBulletFlightTime(double firePower, double targetDistance) {
        return targetDistance / getShotVelocity(firePower);
    }

    public static Coords clip(Coords target, Coords source, Coords dimensions) {
        return target;
        /*
        Coords clipped = null;

        if (target.getY() <= 22.5) {
            clipped = new Coords(
                    (22.5 - target.getY()) * (target.getX() - source.getX())
                            / (target.getY() - source.getY()),
                    22.5);
        } else {
            clipped = target;
        }
        if (clipped.getX() <= 22.5) {
            clipped = new Coords(
                    22.5,
                    (22.5 - clipped.getX()) * (clipped.getY() - source.getY())
                            / (clipped.getX() - source.getX()));
        }
        if (clipped.getY() >= dimensions.getY() - 22.5) {
            clipped = new Coords(
                    (dimensions.getY() - 22.5 - clipped.getY())
                            * (clipped.getX() - source.getX())
                            / (clipped.getY() - source.getY()),
                    dimensions.getY() - 22.5);
        }
        if (clipped.getX() >= dimensions.getX() - 22.5) {
            clipped = new Coords(
                    (dimensions.getX() - 22.5 - clipped.getX())
                            * (clipped.getY() - source.getY())
                            / (clipped.getX() - source.getX()),
                    dimensions.getX() - 22.5);
        }

        return clipped;
        */
    }
}