/*
 * Coords - utility class for Robocode robots.
 * Copyright (C) 2002  Joachim Hofer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * You can contact the author via email (qohnil@johoop.de) or write to
 * Joachim Hofer, Feldstr. 12, D-91052 Erlangen, Germany.
 */

package qohnil.util;

import java.io.Serializable;
import java.awt.geom.Point2D;

public class Coords implements Serializable {

    double x;
    double y;

    public double getX() { return x; }
    public double getY() { return y; }

    public Coords(Coords coords) {
        x = coords.x;
        y = coords.y;
    }

    public Coords(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getDistanceFromWall(Point2D.Double dimension) {
        double distX = Math.min(dimension.getX() - getX(), getX());
        double distY = Math.min(dimension.getY() - getY(), getY());

        return Math.min(distX, distY);
    }

    public void add(Coords coords) {
        x += coords.x;
        y += coords.y;
    }

    public void normalize() {
        double norm = getNorm();
        x /= norm;
        y /= norm;
    }

    public double getNorm() {
        return Math.sqrt(x * x + y * y);
    }

    public double distance(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;

        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Coords c) {
        double dx = this.x - c.x;
        double dy = this.y - c.y;

        return Math.sqrt(dx * dx + dy * dy);
    }

    public String toString() {
        return "[" + getX() + " / " + getY() + "]";
    }

}
