package testantiswapgun;

import java.awt.Graphics2D;
import java.awt.Color;

public class Wave {

	double xOrigin, yOrigin;
	double velocity;
	double timeOrigin;

	double trueBearing;		
	double headOnBearing;
	double bulletBearing;

	public Wave(double x, double y, double v, double t, double b, double bH, double bB){
		xOrigin = x;
		yOrigin = y;
		velocity = v;
		timeOrigin = t;
		
		trueBearing = b;
		headOnBearing = bH;
		bulletBearing = bB;
	}
	
	public double getX( double time, double alpha){
		return xOrigin + getDistanceTravelled(time)*Math.sin(alpha);
	}
	
	public double getY( double time, double alpha){
		return yOrigin + getDistanceTravelled(time)*Math.cos(alpha);
	}
	
	public double getX( double time){
		return getX(time, trueBearing);
	}
	
	public double getY( double time){
		return getY(time, trueBearing);
	}
	
	public double getXBullet( double time){
		return getX(time, bulletBearing);
	}
	
	public double getYBullet( double time){
		return getY(time, bulletBearing);
	}
	
	public double getXHeadOn( double time){
		return getX(time, headOnBearing);
	}
	
	public double getYHeadOn( double time){
		return getY(time, headOnBearing);
	}
	
	public double getDistanceTravelled(double time){
		return velocity*(time-timeOrigin);
	}
	
	public void onPaint(Graphics2D g, double time){
		g.setColor(Color.black);
		double raggio = getDistanceTravelled(time);
		g.drawOval( (int)(xOrigin-raggio), (int)(yOrigin-raggio), (int)(raggio*2), (int)(raggio*2) );
		
		g.setColor(Color.yellow);
		raggio = 20;
		g.drawOval( (int)(getX(time)-raggio), (int)(getY(time)-raggio), (int)(raggio*2), (int)(raggio*2) );
		
		g.setColor(Color.red);
		raggio = 20;
		g.drawOval( (int)(getXBullet(time)-raggio), (int)(getYBullet(time)-raggio), (int)(raggio*2), (int)(raggio*2) );
		
		g.setColor(Color.white);
		/*
		raggio = 20;
		g.drawOval( (int)(getXHeadOn(time)-raggio), (int)(getYHeadOn(time)-raggio), (int)(raggio*2), (int)(raggio*2) );
		*/
	}
	
}
