package theo.simple.gun;
import theo.simple.enemy.Enemy;
import theo.simple.wave.Wave;
import theo.simple.utils.botUtils;
import theo.simple.Bones;
import java.util.*;
import java.awt.geom.Point2D;
import robocode.*;
import robocode.util.*;
/**
 * GHandler - a class by Damij
 */
public class GHandler
{

	AdvancedRobot bot;
	Enemy enemy;
	
	Point2D.Double pos = new Point2D.Double();
	
	static List<Wave> _waveList;
	
	static HashMap<double[],Double> _statsMap;
	List<Double> _neighborList = new ArrayList<Double>();
	
	long currTime;
	
	double[] stats = new double[11];
	
	private static final long NUM_NEIGHBORS = 11;
	
	private double botWidth,bPower,bSpeed;
	
	static {
		_waveList = new ArrayList<Wave>();
		_statsMap = new HashMap<double[],Double>();
	}
	
	public GHandler (AdvancedRobot bot){
		this.bot = bot;
	}
	
	public void update(Enemy enemy, ScannedRobotEvent e){
		this.enemy = enemy;
		this.currTime = this.bot.getTime();		
		
		this.pos = new Point2D.Double(this.bot.getX(),this.bot.getY());
		this.botWidth = this.enemy.botWidth;

		this.setStats();

		this.updateWaves();
		this.calcBPower();
		this.setNeighbors();
		double aimAngle = this.findLiveAngle();
		this.aim(aimAngle);
		this.checkSpawnWave();
	}
	
	private void setStats(){
		this.stats[0] = Math.abs(enemy.velocity/8.0d);
		this.stats[1] = Math.abs(enemy.latVelocity/8.0d);
		this.stats[2] = Math.abs(enemy.changeHead/(Math.PI/10.0d));
		this.stats[3] = Math.abs(enemy.lastVelocity/8.0d);
		this.stats[4] = Math.abs(enemy.velocity-enemy.lastVelocity)/2.0d;
		this.stats[5] = enemy.distance/1000.0d;
		this.stats[6] = this.radianToWallRatio();
		this.stats[7] = Enemy.dirChangeRatio;
		this.stats[8] = this.bSpeed/20.0;
		this.stats[9] = Math.abs(enemy.latHeading/Math.PI);
		//this.stats[10] = Math.abs(enemy.latVelocity-this.bot.getVelocity()*Math.sin(enemy.bearing))/16.0d;
		
		for(int i = 0; i < this.stats.length; i ++){
			this.stats[i] = botUtils.limit(0.0d,this.stats[i],1.0d);
		}
	}
	
	private void updateWaves(){
		for(int w = 0; w < _waveList.size(); w ++){
			Wave prop = _waveList.get(w);
			prop.setDistTraveled((currTime-prop.shotTime)*prop.velocity);
			if(prop.distTraveled >= prop.startPoint.distance(enemy.pos)){
				this.storeWave(prop);
				_waveList.remove(prop);
				w--;
			}
		}
	}
	
	private void storeWave(Wave wave){
		if(wave.isReal){
			_statsMap.put(wave.stats,this.getOffset(wave));
		}
	}
	
	public void calcBPower(){
		if(Bones.isMC){
			this.bPower = 3.0;
		}
		else{
			bPower = 1.8;
			if (enemy.energy < 4.0){
				this.bPower =  botUtils.limit(0.1,enemy.energy / 4.0,3.0);
			}
			else if (enemy.energy <= 16.0){
				this.bPower = botUtils.limit(0.1,(enemy.energy+2.0)/6.0,3.0);
			}
		}
		if(this.bot.getEnergy()<this.bPower&&Bones.isMC){
			this.bPower = this.bot.getEnergy();
		}
		this.bSpeed = botUtils.bSpeed(this.bPower);
	}
	
	private void setNeighbors(){
		this._neighborList = botUtils.findNearestSurfNeighbors(
				this.stats.clone(), _statsMap, NUM_NEIGHBORS);
	}
	
	private double getOffset(Wave wave){
		return Utils.normalRelativeAngle(Math.atan2(enemy.pos.x-wave.startPoint.x,
					enemy.pos.y-wave.startPoint.y)-wave.absAngle)/wave.maxEscapeAngle;
	}

	private double findLiveAngle(){
		int density, maxDensity = 0;
		double aimAngle = enemy.absAngle;
		for(double offset : this._neighborList){
			density = 0;
			double angleA = this.getAngleForOffset(offset);
			for(double offset2 : this._neighborList){
				double angleB = this.getAngleForOffset(offset2);
				if(offset!=offset2){
					double ratio = Utils.normalRelativeAngle(angleB-angleA)/botWidth;
					if(ratio*ratio<this.botWidth/2.0){
						density ++;
					}
				}
			}
			if(density>maxDensity){
				maxDensity = density;
				aimAngle = angleA;
			}
		}
		return aimAngle;
	}
	
	private double getAngleForOffset(double factor){
		return Utils.normalAbsoluteAngle(Math.asin(8.0/this.bSpeed)*factor*Enemy.latDirection + enemy.absBearing);
	}
	
	private void aim(double aimAngle){
		bot.setTurnGunRightRadians(Utils.normalRelativeAngle(aimAngle-bot.getGunHeadingRadians()));
	}
	
	private void checkSpawnWave(){
		if(bot.getGunTurnRemainingRadians()<this.botWidth/2.0){
			if(bot.getGunHeat()==0){
				if(bot.getEnergy()>this.bPower||Bones.isMC){
					if(bot.getEnergy()>0){
						this.spawnWave(true);
					}
				}
			}
		}
	}
	
	private void spawnWave(boolean isReal){
		Wave wave = new Wave();
		wave.startPoint = (Point2D.Double)this.pos.clone();
		wave.absBearing = enemy.absBearing;
		wave.absAngle = enemy.absAngle;
		wave.maxEscapeAngle = Math.asin(8.0/this.bSpeed)*Enemy.latDirection;
		wave.velocity = this.bSpeed;
		wave.shotTime = this.currTime;
		wave.stats = this.stats.clone();
		wave.isReal = isReal;
		_waveList.add(wave);
		if(isReal){
			this.bot.setFire(this.bPower);
		}
	}
	
	public void onDeath(DeathEvent e){
		_waveList.clear();
	}
	
	public void onWin(WinEvent e){
		_waveList.clear();
	}
	
	double radianToWallRatio(){
		Point2D.Double projPos = (Point2D.Double)enemy.pos.clone();
		double mEA = Math.abs(Math.asin(8.0/this.bSpeed)), thetaOffset = 0;
		while(Math.abs(thetaOffset) < mEA && Bones.playField.contains(projPos)){
			thetaOffset += 0.01 * Enemy.latDirection;
			projPos = botUtils.project(this.pos, enemy.distance, enemy.absBearing + thetaOffset);
		}
		thetaOffset = Math.min(Math.abs(thetaOffset), mEA);
		return Math.abs(thetaOffset/mEA);
	}
}
