/*
 * Created on 08/02/2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import axeBots.AxeBot;
import axeBots.GL.BarGraph;
import axeBots.pilot.waves.EnemyWave;
import axeBots.util.AxeFiles;
import axeBots.util.RoboMath;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SegmentedGFs {

    public static final int GF_QT= 65;//17;
    public static final int DISTS= 6;
    public static final int DIST_SLC= 200;
    private BitRater gfs[][]= new BitRater[DISTS][GF_QT];
    private BarGraph graphs[]= null;

    public SegmentedGFs() {

        super();
        init();
        newRound();
    }

    private void init() {
        for (int j= 0; j < DISTS; j++) {
            for (int i= 0; i < GF_QT; i++) {
                gfs[j][i]= new BitRater();
            }
        }
    }

    public void newRound() {
		if(AxeBot.GL){
        
        graphs= new BarGraph[DISTS];
        for (int j= 0; j < DISTS; j++) {
            graphs[j]= new BarGraph((j * 140) + 10, 20, GF_QT, 64);
            graphs[j].setLabel((j * DIST_SLC) + "-" + ((j + 1) * DIST_SLC));
        }}
    }

    public void hit(double bullPw, double angularDelta, double dist) {
        int gf= SegmentedGFs.getGF(bullPw, angularDelta, dist);
        this.updateGFs(gf, dist);

    }

    public void hit(int gf, double bullPw, double dist) {
        //			int gf = SegmentedGFs.getGF( bullPw, angularDelta, dist) ;
        this.updateGFs(gf, dist);

    }

	public int countGF( double dist, int gf, int from, int to) {
		return gfs[this.getDistIndex( dist)][gf].count(from, to);
	}

	public static double getGFArcWdt(double bullPw, double dist){
		double bVel= RoboMath.getBulletVelocity(bullPw);
				//tempo da bala ateh mim
				double timeToMe= dist / bVel;
				// qto posso ter me movido (max)
				double myMaxTravel= timeToMe * AxeBot.MAX_VEL;
				//comprimento da circunferencia
				double cc= 2D * Math.PI * dist;
				//gf +1.0
				return 2D*((myMaxTravel / cc) * 360D);
	}
	
	
	
	public static double getGFSliceWdt(double maxAng){
		return maxAng / GF_QT;
	}
	
    public static int getGF(double bullPw, double angularDelta, double dist) {
        double bVel= RoboMath.getBulletVelocity(bullPw);
        //tempo da bala ateh mim
        double timeToMe= dist / bVel;
        // qto posso ter me movido (max)
        double myMaxTravel= timeToMe * AxeBot.MAX_VEL;
        //comprimento da circunferencia
        double cc= 2 * Math.PI * dist;
        //gf +1.0
        double maxAng= getGFArcWdt(bullPw, dist);
        // tamanho de cada fatia de GF
        double slice= getGFSliceWdt( maxAng);

        double ret= Math.floor((angularDelta + (maxAng/2)) / slice);
        
		ret = (ret>(GF_QT-1))?GF_QT-1:(ret<0)?0:ret;
//        System.out.println(
//            "getGF:"
//                + ret
//                + " bVel:"
//                + bVel
//		+ " dist:"
//						 + dist
//		+ " angularDelta:"
//						  + angularDelta
//                + " timeToMe:"
//                + timeToMe
//                + " myMaxTravel:"
//                + myMaxTravel
//                + " cc:"
//                + cc
//                + " maxAng:"
//                + maxAng
//                + " slice:"
//                + slice);
//        System.out.println(
//            "bullPw:"
//                + bullPw
//                + " angularDelta:"
//                + angularDelta
//                + " dist:"
//                + dist);
        return (int)ret;

    }
    
	public static double getRealGF(double bullPw, double angularDelta, double dist) {
			double bVel= RoboMath.getBulletVelocity(bullPw);
			//tempo da bala ateh mim
			double timeToMe= dist / bVel;
			// qto posso ter me movido (max)
			double myMaxTravel= timeToMe * AxeBot.MAX_VEL;
			//comprimento da circunferencia
			double cc= 2 * Math.PI * dist;
			//gf +1.0
			double maxAng= getGFArcWdt(bullPw, dist);
			// tamanho de cada fatia de GF
			double slice= getGFSliceWdt( maxAng);

			return angularDelta / (maxAng/2);
		}

    private void updateGFs(int hitGF, double dist) {
        if (hitGF > (GF_QT - 1)) {
            System.out.println("ATENCAO: GF ACIMA DO LIMITE:" + hitGF);
            hitGF= GF_QT - 1;
        } else if (hitGF < 0) {
            System.out.println("ATENCAO: GF ABAIXO DO LIMITE:" + hitGF);
            hitGF= 0;
        }
        int ind= this.getDistIndex(dist);
        for (int i= 0; i < GF_QT; i++) {
            gfs[ind][i].set(i == hitGF);

        }
//        print();
    }

    private void print() {
        DecimalFormat forma= new DecimalFormat("00");
        for (int i= 0; i < GF_QT; i++) {
            String line= "";
            for (int j= 0; j < 6; j++) {
                int gf= (i - (int) (SegmentedGFs.GF_QT / 2D));
                line += "GF["
                    + ((gf < 0) ? "" : " ")
                    + gf
                    + "]:"
                    + forma.format(gfs[j][i].count(0, 64))
                    + Character.toString((char)9);
            }
            System.out.println(line);
        }
    }

    private int getDistIndex(double dist) {
        int ret= (int) (dist / DIST_SLC);
        return (ret > (DIST_SLC - 1)) ? (DIST_SLC - 1) : ret;
    }

    public void draw(double dist) {
		if(AxeBot.GL){
        
        int ind= this.getDistIndex(dist);
        for (int i= 0; i < DISTS; i++) {
            int vals[]= new int[GF_QT];
            ArrayList dgr= new ArrayList();
            for (int j= 0; j < GF_QT; j++) {
                vals[j]= gfs[i][j].count(0, 64);
                if (gfs[i][j].count(0, 2) > 0) {
                    dgr.add(new Integer(j));
                }

            }

            if (ind == i) {
                EnemyWave wav= EnemyWave.getCurrentWave(AxeBot.getIt().pos());
                if (wav != null) {

                    graphs[i].highlight(wav.getGF(AxeBot.getIt().pos()));
                } else {
                    graphs[i].highlightOff();
                }
            } else {
                graphs[i].highlightOff();
            }
            graphs[i].setDgrPts(dgr);
            graphs[i].set(vals);
        }}
    }

    public boolean isDangerPoint(int depth, double dist, int gf) {
        return gfs[getDistIndex(dist)][gf].count(0, (depth-1)) > 0;
    }

    public void save(String name) {
        DecimalFormat forma= new DecimalFormat("##0.00");
        DecimalFormat forma2= new DecimalFormat("##0");

        try {
            GZIPOutputStream zipout= null;

            DataOutputStream w= null;
            while (true) {

                try {

                    zipout=
                        AxeFiles.getGZipOutputStream(
                            name + AxeFiles.GFS_FILE_EXTENSION);
                    //zipout.setLevel(9);
                    break;
                } catch (Throwable th) {
                    AxeBot.getIt().out.println(
                        " XXXXXXXXXXXXXXXXXX saving failed:" + th.getMessage());
                }
            }
            //					log.println(" XXXXXXXXXXXXXXXXXX saving OK:");

            //zipout.putNextEntry(new ZipEntry(dataFileName));
            w= new DataOutputStream(zipout);

            for (int j= 0; j < DISTS; j++) {
                for (int i= 0; i < GF_QT; i++) {
                    w.writeLong(gfs[j][i].get());
                }
            }

            // PrintStreams don't throw IOExceptions during prints,
            // they simply set a flag.... so check it here.
            w.flush();
            zipout.finish();
            //zipout.closeEntry();
            w.close();
        } catch (IOException e) {
            AxeBot.getIt().out.println("IOException trying to write: " + e);
        }
    }

    public void load(String name) {
        DataInputStream r= null;
        DecimalFormat forma= new DecimalFormat("##0.00");

        //String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;
        GZIPInputStream zipin= null;
        try {
            File f= AxeFiles.findFile(name + AxeFiles.GFS_FILE_EXTENSION);
            zipin= new GZIPInputStream(new FileInputStream(f));
            //zipin.getNextEntry();

            r= new DataInputStream(zipin); //new FileInputStream(f));

            for (int j= 0; j < DISTS; j++) {
                for (int i= 0; i < GF_QT; i++) {
                    gfs[j][i].load(r.readLong());
                }
            }

        } catch (Throwable e) {
            AxeBot.getIt().out.println("IOException trying to read: " + e);
            // Something went wrong reading the file, Start from scratch
            //			initialise();
        } finally {
            try {
                r.close();
                zipin.close();
            } catch (Throwable e2) {};
        }
    }

    public int getTotHits(double dist) {
        int ret= 0;
        int d= this.getDistIndex(dist);
        for (int i= 0; i < gfs[d].length; i++) {
            ret += gfs[d][i].count(0, 64);
        }
        return ret;
    }

//    public ArrayList getBestGFs(boolean re, double dist) {
//        int d= this.getDistIndex(dist);
//        int start= (re) ? 0 : (GF_QT / 2) + 1;
//        double limit= this.getTotHits(dist) / (double)GF_QT;
//        ArrayList ret= null;
//        while (ret.size() < 3) {
//
//            ret= new ArrayList();
//            for (int i= 0; i < (GF_QT / 2) + 1; i++) {
//
//                if ((gfs[d][i].count(0, 64) < limit)
//                    && (isDangerPoint(3, dist, i))) {
//                    ret.add(new Integer(i));
//                }
//            }
//            limit *= 2D;
//        }
//        return ret;
//    }
	public ArrayList getBestGFs(double dist) {
			int d= this.getDistIndex(dist);
			//int start= (GF_QT / 2) + 1;
			
			
			
			double limit= 4*(this.getTotHits(dist) / (double)GF_QT);
			limit=(limit<1)?1:limit;
			ArrayList ret= new ArrayList();
			while (ret.size() < 3) {

				ret= new ArrayList();
				for (int i= GF_QT/2; i < GF_QT; i++) {

					if ((gfs[d][i].count(0, 64) < limit)
						&& !(isDangerPoint(3, dist, i))) {
						ret.add(new Integer(i));
					}
				}
				limit *= 2D;
			}
			return ret;
		}

    /**
     * @param dist
     * 
     * @author Marcos Machado
     * @since 19/02/2004
     * @modified
     */
    public BitRater[] getBitRater(double dist) {
		int d= this.getDistIndex(dist);
		return gfs[d];
        // TODO Auto-generated method stub
        
    }
	
}
