/*
 * Created on Aug 4, 2003
 *
 */
package jekl;

import java.util.*;
import java.awt.Color;
import java.awt.geom.*;

import robocode.*;
import robocode.util.Utils;

public class StoneGhost extends TeamRobot {
	private static Rectangle2D.Double field;
	private static HashMap enemies;
	private static HashMap statsMap;
    private static final double FULL_TURN 				= 2 * Math.PI;
    private long ticksSinceScan 						= 0;
    private static Point2D.Double myLocation 			= new Point2D.Double();
    private static Point2D.Double propMove 				= new Point2D.Double();
    private static Point2D.Double destination 			= new Point2D.Double();
    private static int wallStrikes = 0;
    private static int finishes[];
	private Enemy target;

	public void run() {
		field = new Rectangle2D.Double(32, 32, getBattleFieldWidth() - 64, getBattleFieldHeight() - 64);
		enemies = new HashMap();
		if (statsMap == null) {
			statsMap = new HashMap();
		}
		if (finishes == null) {
			finishes = new int[getOthers() + 1];
		}
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.GREEN, Color.GREEN, Color.GREEN);
		destination.setLocation(getX(), getY());
		//Every one uses blue. This is for testing only
		turnRadarRightRadians(FULL_TURN);
		while(true) {
			ticksSinceScan++;
			if ((getGunHeat() / getGunCoolingRate() >= 6) || target == null)
				setTarget();
			doStats();
			if (target != null) {
				doMovement();
				doScanner();
				doGun();
			}
			execute();
		}
	}
	
    private void doScanner() {
        double radarOffset;
        if ((getOthers() == 1) || getGunHeat() < .6) {
            if (ticksSinceScan > 4) { 		//if we haven't seen anybody for a bit....
                radarOffset = FULL_TURN; 	//rotate the radar to find a target
            } else {
                radarOffset = Utils.normalRelativeAngle(getRadarHeadingRadians() - getAbsBearing(myLocation, target));
                radarOffset+= ((Math.PI / 10) * (radarOffset < 0 ? -1 : 1));
            }
        } else {
            radarOffset = FULL_TURN;
        }
        //turn the radar
        setTurnRadarLeftRadians(radarOffset);
    }
    
    public void doGun() {
    	int bestIndex = 15;
    	int stats[] = getGuessFactors(target);
		//Get the current best Guess Factor to shoot at
		for (int i = 0; i < stats.length ; i++) {
			if (stats[i] > stats[bestIndex])
				bestIndex = i;
		}
		setTurnGunRightRadians(Utils.normalRelativeAngle(target.absBearing - getGunHeadingRadians() + (target.energy == 0 ? 0 : ((double)bestIndex - 15D) / 15D * Math.asin(8D / (20 - (3 * getFirePower(target)))) * target.cDir)));
		if (getEnergy() > 4) {
			setFire(getFirePower(target));
		} else if (target.energy == 0) {
			setFire(.1);
		}
    }
    
    public void doMovement() {
    	boolean changed = false;
    	Point2D.Double temp = new Point2D.Double(destination.x, destination.y);
        if (Math.abs(getDistanceRemaining()) < 30 || getOthers() > 1) {
        	double ang = 0D;
        	double distance = myLocation.distance(target);
        	//Distance should never be less than 100. Need to play for space :^)
        	distance = getOthers() == 1 ? distance * Math.random() : (distance <= 100 ? 100 : Math.min(500, distance * .5));
        	do {
            	if (field.contains(propMove = projectPoint(myLocation, distance + 18, ang)) && getForces(propMove) + (1D / Math.pow(myLocation.distance(propMove),3)) <= getForces(temp) + (1D / Math.pow(myLocation.distance(temp),3))) {
            		changed = true;
        			temp.setLocation(propMove);
        		} 
    			ang+=.1;
            } while (ang < FULL_TURN);
        }
        if(changed)
        	destination.setLocation(temp);
        goTo(destination);
    }

    public void doStats() {
    	Iterator enemiesIt = enemies.keySet().iterator();
    	while (enemiesIt.hasNext()) {
    		Enemy e = (Enemy)enemies.get((String)enemiesIt.next());
    		Iterator it = e.waves.iterator();
    		while(it.hasNext()) {
    			Wave ew = (Wave)it.next();
    			if(ew.update(e, getTime())) {
    				it.remove();
    			}
    		}
    	}
    }
    
    private double getFirePower(Enemy p) {
    	return Math.min(Math.min(3, 1200D/myLocation.distance(p)), Math.min(getEnergy(),p.energy / 4));
    }
    
    //Utility Methods
    void goTo(Point2D.Double destination) {
        double angle = Utils.normalRelativeAngle(getAbsBearing(myLocation, destination) - getHeadingRadians());
	    double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(Math.abs(getTurnRemainingRadians()) > 1 ? 0 : myLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
    }

	private static double getAbsBearing(Point2D.Double orig, Point2D.Double dest) {
		return Math.atan2(dest.x - orig.x, dest.y - orig.y);
	}

	private static Point2D.Double projectPoint(Point2D.Double p, double dist, double angle) {
		return new Point2D.Double((p.x + (Math.sin(angle) * dist)), (p.y + (Math.cos(angle) * dist)));
	}
	
	//I should try projecting their movement a few ticks out to see where they are when I am evaluating my movement. 
	//This might help a bit.
	private double getForces(Point2D.Double p) {
		double retVal = 0;
        Iterator targetsIterator = enemies.keySet().iterator();
        Enemy en;
        Point2D.Double ePos = new Point2D.Double();
        int closer = 1;
		while (targetsIterator.hasNext()) {
            en = (Enemy) enemies.get((String) targetsIterator.next());
            ePos.setLocation(projectPoint(en, en.heading, (en.velocity * (getTime() - en.lastScanTime))));
            retVal+=((50D + en.energy) * (1 + Math.abs(Math.cos(getAbsBearing(myLocation, p) - getAbsBearing(ePos, myLocation))))) / ePos.distanceSq(p);
            //Is the point closer to him than I am?
            Iterator it = enemies.keySet().iterator();
            //Are more enemies closer than I am?
            while (it.hasNext()) {
            	Enemy e = (Enemy)enemies.get((String)it.next());
            	//If the point is closer to more enemies, I am like to be more targeted so lets count how many I am closer too
            	if(e.distance(p) * 1.1 < myLocation.distance(p)) {
                	//If the enemy is close and has hit me recently, make him more dangerous
            		if (getTime() - e.lastHitMeWithBullet < 50 && myLocation.distance(en) < 400) {
            			retVal*=3;
            		}
            		closer++;
            	}
            }
        }
		//I originally added closer but then it dominated the retVal (retVal was otherwise less than .01 usually)
        //return retVal * closer;
        return retVal;
	}
	
	private void setTarget() {
		double testDist = (target == null ? 10000D : (myLocation.distance(target)));
		Enemy e = null;
		Iterator it = enemies.keySet().iterator();
		while (it.hasNext()) {
			e = (Enemy) enemies.get((String)it.next());
			if (e.dist < testDist * .98) {
				target = e;
				testDist = e.dist;
			}
		}
	}
    
    private int[] getGuessFactors(Enemy e) {
		int[][][][][] stats = (int[][][][][])statsMap.get(e.name);
		if (stats == null) {
			stats = new int[2][5][5][14][31];
			statsMap.put(e.name, stats);
		}
		int factor_1 = (getOthers() > 1 ? 1 :0);
		//int factor_2 = (getOthers() > 1 ? (int)(center.distance(e) / 200) :((int)Math.abs(e.latVel)/3));
		int factor_2 = (int)(Math.abs(e.latVel)/3);
		//int factor_3 = (getOthers() > 13 ? 0 : (e.closingVelocity == 0 ? 0 : e.closingVelocity > 0 ? 1 : 2));
		int factor_3 = (e.closingVelocity == 0 ? 0 : e.closingVelocity > 0 ? 1 : 2);
		int factor_4 = Math.min(13, (int)Math.round((myLocation.distance(e)/(20D - (getFirePower(e) * 3D))/7D)));
		return stats[factor_1][factor_1][factor_3][factor_4];    	
    }
    
    //Event Handlers
	public void onScannedRobot(ScannedRobotEvent ev) {
		//Update the Enemy
		Enemy e = null;
		ticksSinceScan = 0;
		String name = ev.getName();
    	myLocation.setLocation(getX(),getY());
		e = (Enemy)enemies.get(name);
		if (e == null) {
			e = new Enemy();
			e.name = name;
			enemies.put(name, e);
		}
		e.latVel = (e.velocity = ev.getVelocity()) * Math.sin(e.heading = ev.getHeadingRadians() - (e.absBearing = Utils.normalRelativeAngle(getHeadingRadians() + (e.bearing = ev.getBearingRadians()))));
		e.x = getX() + Math.sin(e.absBearing) * (e.dist = ev.getDistance());
		e.y = getY() + Math.cos(e.absBearing) * e.dist;
		e.energy = ev.getEnergy();
		e.lastScanTime = getTime();
		int dir;
		e.cDir = (int)(Math.abs(e.latVel)/e.latVel);
		if (e.cDir == 0)
			e.cDir = 1;
		e.closingVelocity = e.velocity * Math.cos(e.heading - e.absBearing);
		//Add new waves 
		Wave w = new Wave();
		w.bulletVel = 20D - (getFirePower(e) * 3D);
		w.setLocation(myLocation);
		w.lastKnowLocation.setLocation(e);
		w.distTraveled+=w.bulletVel;
		w.startingAbsTargetBearing = e.absBearing;
		w.maxAnglePossible = Math.asin(8D/w.bulletVel) * e.cDir;
		w.lastScanTime = getTime();
		w.shotTime = getTime();
		w.guessFactors = getGuessFactors(e);
		e.waves.add(w);
	}

	public void onRobotDeath(RobotDeathEvent ev) {
		enemies.remove(ev.getName());
		if (target != null && ev.getName().equalsIgnoreCase(target.name)) {
			target = null;
		}
	}
	
	public void onWin(WinEvent ev) {
		onDeath(null);
	}
	
	public void onDeath(DeathEvent ev) {
		finishes[getOthers()]++;
		System.out.println("Finished: " + (getOthers() + 1));
		for (int i=0; i < finishes.length; i++) {
			out.print(finishes[i] + " " + (i == (finishes.length - 1) / 2 ? "| " : ""));
		}
		out.println();
		System.out.println("Wall Strikes: " + wallStrikes);
	}

	public void onBulletMissed(BulletMissedEvent e) {
		
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		Enemy en = (Enemy)enemies.get(e.getName());
		Bullet b = e.getBullet();
		if (en != null)
			en.lastHitMeWithBullet = getTime();
	}
	
	public void onHitWall(HitWallEvent ev) {
		++wallStrikes;
	}
		
	//Inner classes
	private static class Enemy extends Point2D.Double {
		public double absBearing;
		public double dist;
		public double velocity;
		public double energy;
		public double latVel;
		public double heading;
		public double bearing;
		public double closingVelocity;
		public long lastScanTime;
		public long lastHitMeWithBullet;
		public int cDir;
		public String name;
		ArrayList waves = new ArrayList();
	}

	private static class Wave extends Point2D.Double {
		public Point2D.Double lastKnowLocation = new Point2D.Double();				//Last known location
		public double bulletVel;
		public double distTraveled;
		public double startingAbsTargetBearing;
		public double maxAnglePossible;
		public int[] guessFactors;
		public long lastScanTime;
		public long shotTime;
		
		public boolean update(Point2D.Double currentLocation, long currentTime) {
			double dx = (currentLocation.x - lastKnowLocation.x) / (currentTime - lastScanTime);
			double dy = (currentLocation.y - lastKnowLocation.y) / (currentTime - lastScanTime);
			//this projection system is flawed in that it can project beyond the field. This would be a good place for more bytes
			while (lastScanTime < currentTime) {
				if (distTraveled > this.distance(lastKnowLocation)) {
					guessFactors[(int)Math.max(0,Math.min(30,(int) Math.round(((((Utils.normalRelativeAngle(getAbsBearing(this, lastKnowLocation) - startingAbsTargetBearing)) / maxAnglePossible) * 15) + 15))))]++;
					return true;
				}
				distTraveled+=bulletVel;
				lastScanTime++;
				lastKnowLocation.setLocation(lastKnowLocation.getX() + dx, lastKnowLocation.getY() + dy);
			}
			return false;
		}
	}
}