package kawigi.sbf.core;
import kawigi.sbf.utils.*;
import robocode.*;
import java.awt.geom.*;
import java.util.*;

/**
 * MeleeMovement - contains all the general-purpose melee movement for
 * FloodHT in static methods.
 */
public class MeleeMovement
{
	private static Point2D next, last;
	
	public static void init()
	{
		next = null;
		last = null;
	}
	
	public static void minimumRiskMovement(TeamRobot r)
	{
		Point2D myLocation = Utils.getMyLocation();
		VolatileEnemy currentTarget = Utils.getCurrentTarget();
		if (currentTarget != null)
		{
			if (last == null)
				last = new Point2D.Double(myLocation.getX(), myLocation.getY());
			if (next == null)
				next = last;
			boolean changed = false;
			double distance = Math.min(300, myLocation.distance(currentTarget)/2);
			//sometimes I'll change my point here, sometimes I won't.  It's a big mystery!
			for (double angle = 0; angle < Math.PI*2; angle += .1)
			{
				Point2D p = Utils.projectPoint(myLocation, angle, distance);
				if (Utils.inFieldTrunc(p) && findRisk(p, r) < findRisk(next, r))
				{
					changed = true;
					next = p;
				}
			}
			//this helps the whole movement system know what direction I'm going, and avoid head-on targeting:
			if (changed)
				last = myLocation;
			distance = next.distance(myLocation);
			double turn = Utils.angle(next, myLocation)-r.getHeadingRadians();
			if (Math.cos(turn) < 0)
			{
				turn += Math.PI;
				distance = -distance;
			}
			r.setTurnRightRadians(Utils.normalize(turn));
			//avoid running into walls when I'm turning.
			if (!Utils.inField(Utils.projectPoint(myLocation, r.getHeadingRadians(), Math.max(-20, Math.min(20, distance)))))
				distance = 0;
			r.setAhead((Math.abs(r.getTurnRemainingRadians()) > 1) ? 0 : distance);
		}
	}
	
	public static double findRisk(Point2D point, TeamRobot robot)
	{
		Point2D myLocation = Utils.getMyLocation();
		double risk = 4/last.distanceSq(point) + .1/myLocation.distanceSq(point);
		Iterator it = Utils.getEnemies();
		while (it.hasNext())
		{
			VolatileEnemy e = (VolatileEnemy)it.next();
			//start with an anti-gravity-type value:
			double thisrisk = Math.max(robot.getEnergy(), e.energy)/point.distanceSq(e);
			
			//try this, multiply this number by the number of enemies to which I would be the closest:
			//if they are likely targeting me, multiply by some factor that has to do with "perpendicularity"
			//(I think I remember David Alves calling it that):
			//thisrisk *= 1+targetingMeOdds(point, e);
			thisrisk *= 1+targetingMeOdds(point, e)* (Math.abs(Math.cos(Utils.angle(myLocation, point) - Utils.angle(e, myLocation))));
			//if (targetingMeOdds(point, e) > 0 && targetingMeOdds(myLocation, e) == 0)
			//	thisrisk ++;
			thisrisk += targetingMeOdds(point, e)/(5+robot.getOthers());
			
			//don't run into people!  (This is a guess of whether someone is between me and p)
			//I suppose this deserves an explanation.  I'm figuring that if to 36x36 squares will hit each other moving
			//along a certain vector (my vector, and I assume they'll be in roughly the same place), then a line
			//representing the vector will intersect a 72x72 square centered in the same place.
			if (new Line2D.Double(myLocation, point).intersects(new Rectangle2D.Double(e.getX()-36, e.getY()-36, 72, 72)))
				thisrisk *= 4;
			
			risk += thisrisk;
		}
		//if (Math.cos(Utils.angle(myLocation, point)-Utils.angle(myLocation, Utils.projectPoint(myLocation, Utils.getRobot().getHeadingRadians(), Utils.getRobot().getDistanceRemaining()))) < 0)
		//	risk *= 1 + (1-Math.cos(Utils.angle(myLocation, point)-Utils.angle(myLocation, Utils.projectPoint(myLocation, Utils.getRobot().getHeadingRadians(), Utils.getRobot().getDistanceRemaining()))))/4;
		return risk;
	}
	
	public static double targetingMeOdds(Point2D myLocation, VolatileEnemy enemy)
	{
		int closer = 0;
		for (Iterator it = Utils.getEnemies(); it.hasNext();)
		{
			VolatileEnemy e2 = (VolatileEnemy)it.next();
			if (enemy != e2 && enemy.distance(e2)*.9 < enemy.distance(myLocation))
				closer++;
		}
		if (closer <= 0/*Utils.getRobot().getOthers()/5*/ || Utils.getRobot().getTime()-enemy.lastHitTime < 200)
			return 1;
		//else if (enemy == Utils.getCurrentTarget())
		//	return .5;
		else
			return 0;
	}
	
	public static double rawAntigravityAtPoint(Point2D location, VolatileEnemy currentEnemy)
	{
		if (!Utils.inField(location))
			return Double.POSITIVE_INFINITY;
		double total = (1+Math.abs(Math.cos(Utils.angle(currentEnemy, location) - Utils.angle(Utils.getMyLocation(), currentEnemy))))/location.distanceSq(Utils.getMyLocation());
		for (Iterator it = Utils.getEnemies(); it.hasNext();)
		{
			VolatileEnemy next = (VolatileEnemy)it.next();
			if (next != currentEnemy)
				total += (1+Math.abs(Math.cos(Utils.angle(currentEnemy, location) - Utils.angle(next, currentEnemy))))/location.distanceSq(next);
		}
		return total;
	}
}
