/*
 * Created on Feb 15, 2004
 *
 */
package davidalves.net;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import davidalves.net.util.*;

import robocode.RobocodeFileOutputStream;
import robocode.TeamRobot;

public class AdvancedTeamRobot extends TeamRobot {
	
	public static final double SHARP_TURN_FACTOR = 9.0 * 90.0; //Disable sharp turns
	public static final int DUEL = 0;
	public static final int MELEE = 1;
	public static final int TEAM = 2;
	public static final int SURVIVAL = 3;
	public static PrintStream log;
	
	public static AdvancedTeamRobot bot;
	
	public static Rectangle2D robotDimensions;
	public static Point arenaCenter;
	
	public void init(){
		Utils.init(this);
		Point.init(getBattleFieldWidth(), getBattleFieldHeight());
		log = out;
		bot = this;
		robotDimensions = new Rectangle2D.Double(0.0, 0.0, getWidth(), getHeight());
		
	}
	
	protected void driveTo(Point destination) {
		Point myLocation = new Point(getX(), getY());
		double distance = myLocation.distanceTo(destination);
		double angle = Utils.normalRelativeAngle(myLocation.absoluteAngleTo(destination) - getHeadingRadians());
		if (Math.abs(angle) > Math.PI / 2.0) {
			distance *= -1;
			if (angle > 0) {
				angle -= Math.PI;
			}
			else {
				angle += Math.PI;
			}
		}
		
		//setMaxVelocity(SHARP_TURN_FACTOR / Math.abs(getTurnRemaining()));
		
		if(Math.abs(distance) > 5){
			setTurnRightRadians(angle);
		}
		setAhead(distance);
	}
	
	public static void info(String msg){
		if(bot==null){
			log.println("INFO: " + msg);
		} else {
			log.println(bot.getTime() + " INFO: " + msg);
		}
	}
	
	public static void printArray(double[] data){
		StringBuffer s = new StringBuffer(200);
		for(int i = 0; i < data.length; i++){
			s.append(data[i]);
			s.append(" ");
		}
		info(s.toString());
	}
	
	public static void printArray(float[] data){
		StringBuffer s = new StringBuffer(200);
		for(int i = 0; i < data.length; i++){
			s.append(data[i]);
			s.append(" ");
		}
		info(s.toString());
	}
	
	public static void printArray(int[] data){
		StringBuffer s = new StringBuffer(200);
		for(int i = 0; i < data.length; i++){
			s.append(data[i]);
			s.append(" ");
		}
		info(s.toString());
	}
	
	public static void warning(String msg){
		if(bot==null){
			log.println("WARNING: " + msg);
		} else {
			log.println(bot.getTime() + " WARNING: " + msg);
		}
	}
	
	public static void error(String msg){
		if(bot==null){
			log.println("ERROR: " + msg);
		} else {
			log.println(bot.getTime() + " ERROR: " + msg);
		}
	}
	
	// I / O
	
	public Object readObject(String fileName){
		Object o;
		try
		{
			ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(fileName))));
			o = ois.readObject();
			ois.close();
		}
		catch(Exception e)
		{
			warning("IOException trying to read from: " + fileName);
			e.printStackTrace(log);
			return null;
		}
		return o;
	}

	public void writeObject(Object o, String fileName){
		try
		{
			ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(fileName))));
			oos.writeObject(o);
			oos.close();
		}
		catch(Exception e)
		{
			warning("IOException trying to write to: " + fileName);
			e.printStackTrace(log);
		}
	}
	
	public int zipSizeObject(Object o){
		ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
		try
		{
			ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(baos));
			oos.writeObject(o);
			oos.close();
			info("Size of compressed data: " + baos.size() + " bytes.");
		}
		catch(Exception e)
		{
			warning("IOException trying to compress: " + o);
			e.printStackTrace(log);
		}
		return baos.size();
	}
}
