/*
 * Created on Oct 20, 2004
 *
 */
package davidalves.net.movement;

import robocode.util.Utils;
import davidalves.net.util.*;

/**
 * @author David Alves
 * From YALT 1.732
 *
 */
public class RamEvasionWallSmoother extends WallSmoother{
	
	public Point getSmoothedDestination(Point position, Point orbitCenter, double direction) {
		final double STICK_LENGTH = 170;
		
		double desiredAngle = Utils.normalAbsoluteAngle(position.absoluteAngleTo(orbitCenter) - direction * 3.1);
		double angle = desiredAngle;
		int adjustments = 0;
		while((position.project(angle, STICK_LENGTH).distanceToWall() < 10.0))
		{
			adjustments++;
			angle += direction * 0.05;
		}
		return position.project(angle, STICK_LENGTH);
	}
}
