/*
 * Created on Feb 29, 2004
 *
 *
 */

package davidalves.net.util;

import java.awt.geom.Point2D;
import java.io.Serializable;

import davidalves.PhoenixOS;
import davidalves.net.AdvancedTeamRobot;

public class Point implements Serializable{
	
	private static double minX = 0.0, minY = 0.0, maxX = 800.0, maxY = 600.0;
	private static double minDrivableX = 18.0, minDrivableY = 18.0, maxDrivableX = 800.0 - 36.0, maxDrivableY = 600.0 - 36.0; 
	private static double centerX, centerY;
	
	public double x,y;
	
	public static final Point INVALID = new Point(Double.NaN, Double.NaN); 
	static Point origin= new Point(0,0);
	
	public static void init(double battleFieldWidth, double battleFieldHeight){
		maxDrivableX = battleFieldWidth - 36.0;
		maxDrivableY = battleFieldHeight - 36.0;
		centerX = battleFieldWidth / 2.0;
		centerY = battleFieldHeight / 2.0;
		maxX = battleFieldWidth;
		maxY = battleFieldHeight;
	}
	
	
	public Point(double pX, double pY) {
		x = pX;
		y = pY;
	}
	
	public Point(){
		this(0,0);	
	}
	
	//For debugging
	public String toString(){
		return "(" + Math.round(x) + ", " + Math.round(y) + ")";
	}
	
	public Point2D.Double getPoint2D(){return new Point2D.Double(x,y);}
	
	
	public boolean equals(Point p){
		if(this.distanceTo(p) < 1.0)
			return true;
		return false;
	}
	
	public double distanceTo(Point p){
		double deltaX = p.x - x;
		double deltaY = p.y - y;
		return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
	}
	
	public double distanceSquaredTo(Point p){
		double deltaX = p.x - x;
		double deltaY = p.y - y;
		return deltaX * deltaX + deltaY * deltaY;
	}
	
	public boolean isOnField(){
		return x > 0.0 && y > 0.0 && x < maxX && y < maxY;
	}
	
	public boolean isOnDrivableField(){
		return x <= maxDrivableX && x >= minDrivableX && y <= maxDrivableY && y >= minDrivableY;
	}
	
	public boolean isWithinRoundedRectangleOfRadius(double radius){
		//Don't do expensive square root calculations if not in corner
		if (x < maxDrivableX - radius  && x > minDrivableX + radius)
			return true;
		if (y < maxDrivableY - radius  && y > minDrivableY + radius)
			return true;
		
		double roundedRadiusCircleCenterX = radius;
		double roundedRadiusCircleCenterY = radius;
		
		if(x > centerX){
			roundedRadiusCircleCenterX = maxDrivableX - radius;
		}
		if(y > centerY){
			roundedRadiusCircleCenterY = maxDrivableY - radius;
		}
		double deltaX = roundedRadiusCircleCenterX - x;
		double deltaY = roundedRadiusCircleCenterY - y;
		return Math.sqrt(deltaX * deltaX + deltaY * deltaY) < radius;
	}
	
	public double distanceToWall(){		
		if(x > centerX){
			if(y > centerY) return Math.min(maxDrivableY - y, maxDrivableX - x); //top right
			return Math.min(y - minDrivableY, maxDrivableX - x); // top left
		}
		if(y > centerY) return Math.min(maxDrivableY - y, x - minDrivableX); //bottom right
		return Math.min(y - minDrivableY, x - minDrivableX); //bottom left
	}
	
	public double xWallDistance(){
		return Math.min(maxDrivableX - x, x - minDrivableX);
	}
	
	public double yWallDistance(){
		return Math.min(maxDrivableY - y, y - minDrivableY);
	}
	
	public double absoluteAngleTo(Point p){
		return Utils.normalAbsoluteAngle(Math.atan2(p.x - x, p.y - y));
	}
	
	public double angleBetween(Point p1, Point p2){
		return Utils.normalRelativeAngle(this.absoluteAngleTo(p1) - this.absoluteAngleTo(p2));	
	}
	
	public Point project(double angle, double distance) {
		return new Point(x + Math.sin(angle) * distance, y + Math.cos(angle) * distance);
		
	}
	
	public Object clone(){
		return new Point(this.x, this.y);
	}
}