/*
 * Created on Oct 25, 2004
 *
 */
package davidalves.net.util;

import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

import robocode.Robot;

/**
 * @author David Alves
 *
 */
public class Utils {
	
	private static double gunCoolingRate = 0.1;
	private static DecimalFormat twoDigits = new DecimalFormat("###############0.00");
	public static double maxDrivableX, maxDrivableY, minDrivableX, minDrivableY, centerX, centerY;
	
	public static void init(Robot bot){
		gunCoolingRate = bot.getGunCoolingRate();
		minDrivableX = 18.0;
		maxDrivableX = bot.getBattleFieldWidth() - 36.0;
		minDrivableY = 18.0;
		maxDrivableY = bot.getBattleFieldHeight() - 36.0;
		centerX = bot.getBattleFieldWidth() / 2.0;
		centerY = bot.getBattleFieldHeight() / 2.0;
	}
	
	/*
	 * Bullet power / firing methods
	 * 
	 */
	
	public final double firingFrequency(double bulletPower){
		return Math.ceil((1.0 + Utils.bindToRange(.1, bulletPower, 3.0)/5.0) / gunCoolingRate);
	}
	
	public static double powerNeededToKill(double robotEnergy){
		if (robotEnergy > 16){
			return 3;
		} else if (robotEnergy > 4){
			return (robotEnergy + 2) / 6;
		} else {
			return robotEnergy / 4;
		}
	}
	
	public static final double energyGain(double bulletPower){
		return 3.0 * Utils.bindToRange(.1, bulletPower,3.0);
	}
	
	public static final double bulletDamage(double bulletPower){
		bulletPower = Utils.bindToRange(.1, bulletPower, 3.0);
		
		if(bulletPower > 1.0)
			return bulletPower * 6.0 - 2.0;
			
		return bulletPower * 4.0;
	}

	public static final double bulletSpeed(double bulletPower){
		return (20.0 - 3.0 * Utils.bindToRange(.1, bulletPower, 3.0));
	}
	
	/*
	 * Trig
	 * 
	 */
	
	public static double normalAbsoluteAngle(double angle) {
		while(angle < 0.0){
		 	angle += 2.0 * Math.PI;
		}
		while(angle >= 2.0 * Math.PI){
		 	angle -= 2.0 * Math.PI;
		}
		return angle;
	}
		
	public static double normalRelativeAngle(double angle) {
		while(angle <= -Math.PI){
			angle += 2.0 * Math.PI;
		}
		while(angle > Math.PI){
			angle -= 2.0 * Math.PI;
		}
		return angle;
	}
	
	public static final double angularDifferenceBetween(double fromAngle, double toAngle){
		return Utils.normalRelativeAngle(toAngle - fromAngle);
	}

	public static final double normalRelativeAngle0to90(double ang){
		while(ang > Math.PI / 2.0)
			ang -= Math.PI;
			
		while(ang < - Math.PI / 2.0)
			ang += Math.PI;
			
		return Math.abs(ang);
	}
	
	public static double angle(double x1, double y1, double x2, double y2){
		return Math.atan2(x2 - x1, y2 - y1);
	}
	
	/*
	 * General Math
	 * 
	 */

	public static double rollingAverage(double n, double oldVal, double entry){
		return (n * oldVal + entry)/(n + 1.0);
	}
	
	public static final double random(double min, double max){
		return Math.random() * (max - min) + min;
	}

	public static final double sign(double num){
		if(num > 0.0)
			return 1.0;
		
		if (num < 0.0)
			return -1.0;
		return 0.0;
	}

	public static final double scaledValue(double val1, double val2, double val1factor){
		return val2 + (val1 - val2) * val1factor;
	}

	public static final double bindToRange(double minimumValue, double value, double maximumValue)
	{
		if(value < minimumValue)
			return minimumValue;
		if(value > maximumValue)
			return maximumValue;
		return value;
	}
	/*
	 * Other
	 *
	 */

	public static final double maxTurnRate(double velocity){
		return Math.toRadians(10.0 - .75 * Math.abs(velocity));
	}

	public static final double maxEscapeAngle(double bulletPower){
		//TODO: Find actual max escape angle
		return 1.2 * Math.asin(Math.abs(8.0 / bulletSpeed(bulletPower)));
	}
	
	/**
	 * See <a href="http://www.robowiki.net/cgi-bin/robowiki?Trigonometry/TurnCircleRadius">
	 * http://www.robowiki.net/cgi-bin/robowiki?Trigonometry/TurnCircleRadius
	 * </a> for a description of this method.
	 * 
	 * @author David Alves
	 * @param velocity - velocity that the robot is traveling at
	 * @return the radius of the turning circle if the robot is traveling in a circle, turning at max velocity 
	 */
	public static double turnCircleRadius(double velocity){
		//return 10.0 - .75 * Math.abs(velocity);
		
		return (Math.abs(velocity) * 360.0 / (10.0 - .75 * Math.abs(velocity))) / (2.0 * Math.PI);
	}
	
	public static final String format(double d){
		return twoDigits.format(d);
	}
	
}

