/*
 * Created on 2004-9-25
 */
package tide;

/**
 * event listener. if you want to deal with a certain event, 
 * you can overwrite the certain event handle method, and add the 
 * listener to the Robot. when the certain event occurred,
 * the certain event handle method will be called by the Robot.
 * 
 * @author xiemin
 */
public class EventListener
{
	/**
	 * robot console
	 */
	protected RobotConsole console;
	
	/**
	 * create a event listener
	 * @param console robot console
	 */
	public EventListener(RobotConsole console)
	{
		this.console = console;
	}
	
	/**
	 * This method will be called per tick.
	 */
	public void onWork(){}
	
	/** 
	 * This methed will by called when a new round begin.
	 */
	public void onRoundBegin(){}
	
	/**
	 * This methed will by called when current round finish.
	 */
	public void onRoundFinish(){}
	
	/** 
	 * This methed will by called when a new battle begin.
	 */
	public void onBattleBegin(){}
		
	/**
	 * This methed will by called when current battle finish.
	 */
	public void onBattleFinish(){}
	
    /**
     * This method will be called when your robot sees another robot.
     */
	public void onScannedRobot(ScannedRobotEvent event){}
	
	/**
	 * This method will be called when one of your bullets hits another robot.
	 */
	public void onBulletHit(BulletHitEvent event){}
	
	/**
	 * This method will be called when your robot is hit by a bullet.
	 */
	public void onHitByBullet(HitByBulletEvent event){}
	
	/**
	 * This method will be called when one of your bullets hits another bullet.
	 */
	public void onBulletHitBullet(BulletHitBulletEvent event){}
	
	/**
	 * This method will be called when your robot collides with another robot.
	 */
	public void onHitRobot(HitRobotEvent event){}
	
	/**
	 * This method will be called when your robot collides with a wall.
	 */
	public void onHitWall(HitWallEvent event){}
	
	/**
	 * This method will be called if another robot dies.
	 */
	public void onRobotDeath(RobotDeathEvent event){}
	
	/**
	 * This method will be called if you are taking an 
	 * extremely long time between two tick.
	 */
	public void onOvertime(OvertimeEvent event){}
	
	/**
	 * This method will be called when your robot receives a message
	 * from a teammate.
	 */
	public void onMessageReceived(MessageEvent e){}
	
}
