/*
 * Created on 2004-9-25
 */
package tide.pear;

import tide.EventListener;
import tide.RobotConsole;
import tide.RobotDeathEvent;
import tide.ScannedRobotEvent;
import tide.util.MathUtils;

/**
 * ״
 * @author xiemin
 */
public class RadarController extends EventListener
{
	//˵ĵǰ
	private double x, y;
	//ǰǷѾٵ˵
	private boolean isTraked;
	
	/**
	 * @param console
	 */
	public RadarController(RobotConsole console)
	{
		super(console);
		// TODO Auto-generated constructor stub
	}
	
	/* (non-Javadoc)
	 * @see bridge.EventListener#onScannedRobot(bridge.ScannedRobotEvent)
	 */
	public void onScannedRobot(ScannedRobotEvent event)
	{
		isTraked = true;
		this.x = event.getX();
		this.y = event.getY();
	}
	
	/* (non-Javadoc)
	 * @see bridge.EventListener#onRoundBegin()
	 */
	public void onRoundBegin()
	{
		isTraked = false;
		isEnemyAlive = true;

	    Pear.log("Lost Scan Total Time : " + lostScaneTime);
	}
	
	/* (non-Javadoc)
	 * @see tide.EventListener#onRobotDeath(tide.RobotDeathEvent)
	 */
	public void onRobotDeath(RobotDeathEvent event) {
		isEnemyAlive = false;
	}
	private boolean isEnemyAlive = true;
	private long lostScaneTime = 0;
	
	private double lastBearing = 0.1;
	/* (non-Javadoc)
	 * @see bridge.EventListener#onWork()
	 */
	public void onWork()
	{
		double bearing = lastBearing;
		if(!isTraked) {
			bearing = bearing > 0 ? Math.PI*4 : -Math.PI*4;
			if(console.getTime() > 20 && isEnemyAlive){
			    lostScaneTime++;
			    Pear.log("Lost Scan : " + lostScaneTime);
			}
		}else{
			double heading = MathUtils.heading(console.getX(), console.getY(), x, y);
			bearing = MathUtils.bearing(heading, console.getRadarHeading())*2;
			lastBearing = -bearing;
		}
		
		if( Math.abs(bearing)< Math.toRadians(10))
		{
			bearing = ( bearing > 0 ? 1 : -1 )*Math.toRadians(10);
		}
		console.turnRader(bearing);
		isTraked = false;
	}
}
