/*
 * Created on 2004-10-8
 */
package tide.pear.statistic;

import java.util.ArrayList;
import java.util.List;

import tide.pear.Pear;
import tide.util.Statist;

/**
 * A CombinStatist contains a list of Statist,
 * It can rate all statists in its list,
 * It returns the factor relative to all the statists
 * @author iiley(Chen Jing)
 */
public class CombinStatist implements Statist {
	private int size;
	private List statists;
	private float[] factors;
	private int   highestIndex;
	private float highestFactor;
	private long  updateTime;
	
	public CombinStatist(){
		size = -1;
		statists = new ArrayList();
	}
	
	/**
	 * Add a statist to combin.
	 * If the list of statists is empty set the CombinStatist's size to its size,
	 * then add it to the list return true;
	 * else if the statist's size equals to the CombinStatist's size add it,return ture;
	 * else return false 
	 * @param statist
	 * @return if added successed return true,else return false
	 */
	public boolean add(Statist statist){
		if(size < 0){
			size = statist.size();
			factors = new float[size];
		}
		if(statist.size() == size){
			statists.add(statist);
			return true;
		}else{
			return false;
		}
	}
	
	private void checkUpdate(){
		if (updateTime != Pear.staticGetConsole().getTime()) {
			highestIndex = size/2;
			for (int i = 0; i < size; i++) {
				factors[i] = getInnerFactor(i);
				if (factors[i] > factors[highestIndex]) {
					highestIndex = i;
				}
			}
			highestFactor = factors[highestIndex];
			if(highestFactor == 0f){
				highestFactor = 0.0000001f;
			}
			updateTime = Pear.staticGetConsole().getTime();
		}
	}
	
	private float getInnerFactor(int index){
		float factor = 0;
		for(int i=0; i<statists.size(); i++){
			Statist st = (Statist)statists.get(i);
			factor += st.getFactor(index)/st.getWeigh();
		}
		return factor;
	}
	
	
	/* (non-Javadoc)
	 * @see tide.util.Statist#getFactor(int)
	 */
	public float getFactor(int index) {
		checkUpdate();
		return factors[index]/highestFactor;
	}

	/**
	 * The size was -1 when there was no statist in the list.
	 * The size will be equals to the size of statists in the list
	 * @see tide.util.Statist#size()
	 */
	public int size() {
		return size;
	}

	/**
	 * Rate all the statist in the list.
	 * @see tide.util.Statist#rate(int)
	 */
	public void rate(int index) {
		for(int i=0; i<statists.size(); i++){
			Statist st = (Statist)statists.get(i);
			st.rate(index);
		}
	}

	/**
	 * RateToHighest all the statist in the list.
	 * @see tide.util.Statist#rateHit(int)
	 */
	public void rateHit(int index) {
		for(int i=0; i<statists.size(); i++){
			Statist st = (Statist)statists.get(i);
			st.rateHit(index);
		}
	}
		
	/**
	 * Return the highest factor index relative to all statist in the list.
	 * The factor of every index use getFactor(int) of this class method to get.
	 * @see tide.util.Statist#getHighestFactorIndex()
	 */
	public int getHighestFactorIndex() {
		checkUpdate();
		return highestIndex;
	}

	/**
	 * Return the summation of all statists in the list.
	 * @see tide.util.Statist#getWeigh()
	 */
	public float getWeigh() {
		float sum = 0;
		for(int i=0; i<statists.size(); i++){
			Statist st = (Statist)statists.get(i);
			sum += st.getWeigh();
		}
		return sum;
	}

}
