/*
 * Created on 2004-11-4
 */
package tide.pear.statistic;

import tide.util.Statist;

/**
 * @author iiley(Chen Jing)
 */
public class MyStatistManager2 {
	public static final int BULLET_D = 2;
	public static final int DIST_D = 2;
	public static final int VELOCITY_D = 3;
	public static final int WALL_D = 2;
	public static final int BEARING_D = 3; //if this changed method getBearingIndex should change too
	public static final int MOVETIME_D = 5;
	
	public static final double[] BULLET_SEG = {1.5};
	public static final double[] DIST_SEG = {350};
	public static final double[] VELOCITY_SEG = {2.5, 6.5};

	protected final int FACTORS;
	
	protected Statist           fastHitBuffer;
	protected Statist[][]         velocityHitBuffer;
	protected Statist[][][]       distVeloBuffer;
	protected Statist[][][]       veloMTBuffer;
	protected Statist[][][]       veloWallBuffer;
	protected Statist[][][]       wallMTBuffer;
	protected Statist[][][]       veloBearBuffer;
	protected Statist[][][][]     distVeloMTBuffer;
	protected Statist[][][][]     distVeloWallBuffer;
	protected Statist[][][][][]   slowHitBuffer;
	protected Statist[][][][]     fastBasicBuffer;
	protected Statist[][][][][][] slowBasicBuffer;
	
	/**
	 * Create a StatistManager with a certain factors size
	 * @param FACTORS factors size
	 */
	public MyStatistManager2(int FACTORS){
		this.FACTORS = FACTORS;
		int middleIndex = (FACTORS - 1)/2;
		//init statists
		velocityHitBuffer   = new Statist[BULLET_D][VELOCITY_D];
		distVeloBuffer      = new Statist[BULLET_D][DIST_D][VELOCITY_D];
		wallMTBuffer        = new Statist[BULLET_D][WALL_D][MOVETIME_D];
		veloWallBuffer      = new Statist[BULLET_D][VELOCITY_D][WALL_D];
		veloMTBuffer        = new Statist[BULLET_D][VELOCITY_D][MOVETIME_D];
		veloBearBuffer      = new Statist[BULLET_D][VELOCITY_D][BEARING_D];
		distVeloMTBuffer    = new Statist[BULLET_D][DIST_D][VELOCITY_D][MOVETIME_D];
		distVeloWallBuffer  = new Statist[BULLET_D][DIST_D][VELOCITY_D][WALL_D];
		slowHitBuffer       = new Statist[BULLET_D][DIST_D][VELOCITY_D][WALL_D][MOVETIME_D];
		
		fastBasicBuffer     = new Statist[BULLET_D][DIST_D][VELOCITY_D][MOVETIME_D];
		slowBasicBuffer     = new Statist[BULLET_D][DIST_D][VELOCITY_D][BEARING_D][WALL_D][MOVETIME_D];
		
		float initWeigh = 1f;
		float initWeight = 0.1f;
		//init statists
		fastHitBuffer       = new BasicHitStatist(FACTORS, initWeigh*50, initWeight);
		for(int bpd=0; bpd<BULLET_D; bpd++){
			
		for(int vd=0; vd<VELOCITY_D; vd++){
			velocityHitBuffer[bpd][vd] = new BasicHitStatist(FACTORS, initWeigh*32, initWeight);
			for(int bd=0; bd<BEARING_D; bd++){
				veloBearBuffer[bpd][vd][bd] = new BasicHitStatist(FACTORS, initWeigh*16, initWeight);
			}
			for(int md=0; md<MOVETIME_D; md++){
				veloMTBuffer[bpd][vd][md] = new BasicHitStatist(FACTORS, initWeigh*16, initWeight);
			}
			for(int wd=0; wd<WALL_D; wd++){
				veloWallBuffer[bpd][vd][wd] = new BasicHitStatist(FACTORS, initWeigh*16, initWeight);
			}
		}
		for(int wd=0; wd<WALL_D; wd++){
			for(int md=0; md<MOVETIME_D; md++){
				wallMTBuffer[bpd][wd][md] = new BasicHitStatist(FACTORS, initWeigh*16, initWeight);
			}
		}
		for(int dd=0; dd<DIST_D; dd++){
			for(int vd=0; vd<VELOCITY_D; vd++){
				distVeloBuffer[bpd][dd][vd] = new BasicHitStatist(FACTORS, initWeigh*16, initWeight);

				for(int md=0; md<MOVETIME_D; md++){
					distVeloMTBuffer[bpd][dd][vd][md] = new BasicHitStatist(FACTORS, initWeigh*4f, initWeigh*1f);
					
					fastBasicBuffer[bpd][dd][vd][md] = new BasicStatist(FACTORS, 40f, 0.01f);
				}
				for(int wd=0; wd<WALL_D; wd++){
					distVeloWallBuffer[bpd][dd][vd][wd] = new BasicHitStatist(FACTORS, initWeigh*4f, initWeight*1f);

					for(int md=0; md<MOVETIME_D; md++){
						slowHitBuffer[bpd][dd][vd][wd][md] = new BasicHitStatist(FACTORS, initWeigh*1f, initWeight);
					}
				}
				
				for(int bd=0; bd<BEARING_D; bd++){
					for(int wd=0; wd<WALL_D; wd++){
						for(int md=0; md<MOVETIME_D; md++){
							slowBasicBuffer[bpd][dd][vd][bd][wd][md] = new BasicStatist(FACTORS, 50f);
						}
					}
				}
			}
		}
		}
		
	}
	
	/**
	 * return the statist of given division
	 * @param distIndex
	 * @param veloIndex
	 * @param bearingIndex
	 * @param wallIndex
	 * @param mtIndex
	 * @return the statist of given division
	 */
	public Statist getStatists(int bulletIndex, int distIndex, int veloIndex, int bearingIndex, int wallIndex, int mtIndex, int accIndex, boolean realBullet){
		CombinStatist combinStatist = new CombinStatist();
		
		//if (realBullet) {
			combinStatist.add(fastHitBuffer);
			//combinStatist.add(velocityHitBuffer[bulletIndex][veloIndex]);
			combinStatist.add(distVeloBuffer[bulletIndex][distIndex][veloIndex]);
			//combinStatist.add(veloMTBuffer[bulletIndex][veloIndex][mtIndex]);
			//combinStatist.add(veloWallBuffer[bulletIndex][veloIndex][wallIndex]);
			//combinStatist.add(veloBearBuffer[bulletIndex][veloIndex][bearingIndex]);
			//combinStatist.add(wallMTBuffer[bulletIndex][wallIndex][mtIndex]);

			//combinStatist.add(distVeloMTBuffer[bulletIndex][distIndex][veloIndex][accIndex]);
			//combinStatist.add(distVeloWallBuffer[bulletIndex][distIndex][veloIndex][wallIndex]);
			combinStatist.add(slowHitBuffer[bulletIndex][distIndex][veloIndex][wallIndex][accIndex]);
		//}
		//combinStatist.add(fastBasicBuffer[bulletIndex][distIndex][veloIndex][mtIndex]);
		combinStatist.add(slowBasicBuffer[bulletIndex][distIndex][veloIndex][bearingIndex][wallIndex][mtIndex]);
		
		return combinStatist;
	}
}
