package nat.ether;

import robocode.*;
import nat.*;
import nat.ether.stats.*;
import nat.ether.utils.*;
import nat.ether.wavesurfing.*;
import java.awt.*;

public class EtherDrive {
	private static StatsManager stats;
	private WaveSurfingEngine engine;
	private WaveManager manager;
	private Hikari r;
	
	private int lastDir = 1;
	
	public EtherDrive(Hikari r) {
		FastTrig.init();
		
		this.r = r;
		if (stats == null)
			stats = new StatsManager();
		manager = new WaveManager();
		engine = new WaveSurfingEngine(stats, manager, r);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		
		Store scan = new Store();
		scan.latvel = (float) (r.getVelocity()*Math.sin(e.getBearingRadians()));
		scan.dir = (int) M.signum(scan.latvel);
		if (scan.dir == 0)
			scan.dir = lastDir;
		lastDir = scan.dir;
		
		manager.onTick(e, r.enemyLocation, r.myLocation, scan);
		engine.onScannedRobot(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		manager.onHitByBullet(e);
		engine.onHitByBullet(e);
	}
	
	public void onBulletHit(BulletHitEvent e) {
		manager.onBulletHit(e);
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		engine.onBulletHitBullet(e);
		
	}
	
	public void onPaint(Graphics2D g) {
		manager.onPaint(g);
		engine.onPaint(g);
	}
}
