package suh.radar;

import robocode.*;
import robocode.util.Utils;

public class Radar1on1 extends Radar {
    public Radar1on1(AdvancedRobot robot) {
	super(robot);
    }
    
    @Override
    public void init() {
	self.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    
    @Override
    public void onSkippedTurn(SkippedTurnEvent e) {
	init();
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	self.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle(self.getHeadingRadians() + e.getBearingRadians() - self.getRadarHeadingRadians()));
    }
}
