package simonton.guns.singleTick;

public class History extends Pattern {
	public Speculation speculator;
	
	private short[] codes = new short[50000];
	private int patternLength;
	
	private int startOfRound = 0;
	private int next = 0;

	public History(int targetLength) {
		this.patternLength = targetLength;
		speculator = new Speculation(targetLength);
	}
	
	public void record(short code) {
		codes[next++] = code;
		++length;
		speculator.record(code);
	}

	public void endRound() {
		startOfRound = next;
		length = 0;
		speculator = new Speculation(patternLength);
	}
	
	public Pattern targetPattern() {
		int length = speculator.pastLength;
		Pattern pattern = new SubHistory(next - length, (short) length, codes);
		pattern.hashCode = speculator.pastHashCode;
		return pattern;
	}

	@Override
	public short getCode(int i) {
		assert i >= 0;
		assert i < length;
		
		return codes[startOfRound + i];
	}

	@Override
	public int hashCode() {
		throw new UnsupportedOperationException();
	}

	@Override
	public Pattern subPattern(short subLength) {
		assert subLength >= 0;
		assert subLength <= length;

		int subStart = next - subLength;
		Pattern subPattern = new SubHistory(subStart, subLength, codes);
		int code;
		int shift;
		int subHashCode = 0;
		for (int i = subLength; --i >= 0;) {
			shift = i % 32;
			code = codes[subStart + i];
			subHashCode ^= (code >>> shift) | (code << (32 - shift));
		}
		subPattern.hashCode = subHashCode;
		return subPattern;
	}

	static class SubHistory extends Pattern {
		private int start;
		private short[] codes;

		SubHistory(int start, short length, short[] codes) {
			this.length = length;
			this.start = start;
			this.codes = codes;
		}

		@Override
		public short getCode(int i) {
			assert i >= 0;
			assert i < length;
			
			return codes[start + i];
		}

		@Override
		public Pattern subPattern(short subLength) {
			assert subLength >= 0;
			assert subLength <= length;

			int subStart = length - subLength;
			Pattern subPattern = new SubHistory(start + subStart,
					subLength, codes);

			int subHashCode = hashCode;
			for (int i = 0; i < subStart; ++i) {
				subHashCode ^= codes[i + start];
				subHashCode = (subHashCode << 1) | (subHashCode >>> 31);
			}
			subPattern.hashCode = subHashCode;

			return subPattern;
		}
	}
	
	public static void main(String[] args) {
		History history = new History(2);
		Pattern p = history.subPattern((short) 0);
		history.record((short) 13);
		p = history.subPattern((short) 1);
		history.record((short) 42);
		p = history.subPattern((short) 2);
		p = p.subPattern((short) 1);
		p = p.subPattern((short) 0);
	}
}
