package simonton.guns.singleTick;

abstract public class Pattern {
	protected int hashCode;
	protected short length;

	abstract public short getCode(int i);
	abstract public Pattern subPattern(short subLength);

	@Override
	public boolean equals(Object o) {
		Pattern him = (Pattern) o;
		if (hashCode != him.hashCode || length != him.length) {
			return false;
		}
		for (int i = length; --i >= 0;) {
			if (getCode(i) != him.getCode(i)) {
				return false;
			}
		}
		return true;
	}

	@Override
	public int hashCode() {
		return hashCode;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(hashCode).append(':');
		for (int i = 0; i < length; ++i) {
			sb.append(getCode(i)).append(',');
		}
		return sb.toString();
	}
}
