package simonton.guns.singleTick;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;

import robocode.*;
import simonton.core.*;
import simonton.guns.Gun;
import simonton.utils.*;

public class SingleTickGun extends Gun {
	private int distanceSlicer;
	private int wallDistanceSlicer;

	private Collection<Point2D.Double> predictions = new ArrayList<Point2D.Double>();
	private SingleTickPatternMatcher[][] matchers;
	private History history;
	private History flipVHHistory;

	private int lastNZV;
	private int lastTime = -2;
	private int lastHalfH;
	private int lastV;

	public SingleTickGun(int patternLength, int distanceSlicer,
			int wallDistanceSlicer) {
		this.distanceSlicer = distanceSlicer;
		this.wallDistanceSlicer = wallDistanceSlicer;
		history = new History(patternLength);
		flipVHHistory = new History(patternLength);
		matchers = new SingleTickPatternMatcher[9][1 + (int) Math.hypot(
				Util.botBounds.width, Util.botBounds.height)
				/ distanceSlicer];
		for (int i = 9; --i >= 0;) {
			for (int j = matchers[i].length; --j >= 0;) {
				matchers[i][j] = new SingleTickPatternMatcher(66);
			}
		}
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		super.onScannedRobot(e);
		predictions.clear();

		int halfH = (int) e.getHeading() / 2;
		int v = (int) Math.rint(e.getVelocity());
		int t = (int) getTime();
		if (t - lastTime != 1) {
			System.out.println("Scan discontinuity (this=" + t + ", last=" + lastTime + ")");
			history.endRound();
			flipVHHistory.endRound();
			lastHalfH = halfH;
			lastTime = t;
			lastV = v;
			if (v != 0) {
				lastNZV = v;
			}
			return;
		}

		int h = (int) (e.getHeading() + .5);
		Point2D.Double myP = new Point2D.Double(getX(), getY());
		Point2D.Double enemyP = Util.project(this, e);

		// record.
		int dv = v - lastV;
		int halfDH = Util.normalize(2 * (halfH - lastHalfH)) / 2;
		if (halfDH < -5) {
			halfDH = -5;
		} else if (halfDH > 5) {
			halfDH = 5;
		}
		byte step = encode(dv, halfDH);
		byte flipVH = encode(-dv, -halfDH);
		if (getEnergy() > 0) {
			history.speculator.reset();
			flipVHHistory.speculator.reset();
			if (lastNZV >= 0) {
				matchers[lastV][distanceSegment(myP, enemyP)]
						.record(step, history.targetPattern());
			} else {
				matchers[-lastV][distanceSegment(myP, enemyP)]
						.record(flipVH, flipVHHistory.targetPattern());
			}
		}

		if (v != 0) {
			lastNZV = v;
		}
		int nzv = lastNZV;
		if (v != 0) {
			nzv = lastNZV = v;
		}
		int segment = segment(enemyP, h, nzv);
		history.record((short) (step * segment));
		flipVHHistory.record((short) (flipVH * segment));
		lastHalfH = halfH;
		lastTime = t;
		lastV = v;

		// aim.
		if (shouldAim()) {
			for (Wave shot = Wave.getNextShot(this); t < shot
					.impactTime(enemyP); ++t) {
				if (v != 0) {
					nzv = v;
				}
				if (nzv >= 0) {
					step = (byte) matchers[v][distanceSegment(myP, enemyP)]
							.predictTickAfter(history.speculator, step, 6);
					halfDH = decodeHalfDH(step);
					dv = decodeDV(step);
				} else {
					flipVH = (byte) (matchers[-v][distanceSegment(myP,
							enemyP)].predictTickAfter(
							flipVHHistory.speculator, flipVH, 6));
					halfDH = -decodeHalfDH(flipVH);
					dv = -decodeDV(flipVH);
				}
				h += 2 * halfDH;
				v += dv;
				if (v > 8) {
					System.out.println("limit");
					v = 8;
					dv = 0;
				} else if (v < -8) {
					System.out.println("limit");
					v = -8;
					dv = 0;
				}
				enemyP = Util.project(enemyP, v, h);
				if (Util.inBound(enemyP, 18)) {
					v = 0;
					dv = -8;
				}
				predictions.add(enemyP);
				
				step = encode(dv, halfDH);
				flipVH = encode(-dv, -halfDH);
				if (v != 0) {
					nzv = v;
				}
				segment = segment(enemyP, h, nzv);
				history.speculator.speculate((short) (step * segment));
				flipVHHistory.speculator.speculate((short) (flipVH * segment));
			}
		}
		double gunTurn = Util.bearing(myP, enemyP) - getGunHeadingRadians();
		setTurnGunRightRadians(Util.normalize(gunTurn));
	}

	@Override
	public void onPaint(Graphics2D g) {
		super.onPaint(g);
		g.setColor(Color.BLUE);
		for (Point2D.Double p : predictions) {
			g.fillOval((int) p.x - 1, (int) p.y - 1, 3, 3);
		}
	}

	private int distanceSegment(Point2D.Double myP, Point2D.Double enemyP) {
		if (distanceSlicer >= 1000) {
			return 0;
		}
		return (int) myP.distance(enemyP) / distanceSlicer;
	}

	private int segment(Point2D.Double enemyP, int h, int nzv) {
		if (Util.wallDistance(enemyP, h, nzv) < wallDistanceSlicer) {
			return -1;
		}

		return 1;

		// segmenting on running out of energy, after more thought, seems
		// pointless
		// if (Util.predictEnergy(this, time) == 0) {
		// return -1;
		// }
		// return 1;

		// segementing on wave crashes is no good
		// maybe if we only used it for past history, then used unsegemnted data
		// for
		// future?
		// for (Wave wave : Util.waves) {
		// if (wave.impactTime(pos) == time + 2) {
		// return -1;
		// }
		// }
		// return 1;
	}

	static private byte encode(int dv, int halfDH) {
		assert halfDH >= -5 && halfDH <= 5;
		assert dv >= -8 && dv <= 8;
		if (dv < -2 || dv > 2) {
			return (byte) ((halfDH + 5) * 6);
		}
		return (byte) ((halfDH + 5) * 6 + dv + 3);
	}

	static private int decodeHalfDH(byte code) {
		return code / 6 - 5;
	}

	static private int decodeDV(byte code) {
		return code % 6 - 3;
	}
}
