package hamilton;

public class Statistic
{
	double sum;
	double sumOfSquares;
	int count;
	
	int WINDOW = 1000;
	double FACTOR = 1 - (1 / WINDOW);
	
	public Statistic()
	{
		sum = 0;
		sumOfSquares = 0;
		count = 0;
	}
	
	public Statistic(double someObservation)
	{
		sum = 0;
		sumOfSquares = 0;
		count = 0;

		addObservation(someObservation);
	}
	
	public Statistic(double someSum, double someSumOfSquares, int someCount)
	{
		sum = someSum;
		sumOfSquares = someSumOfSquares;
		count = someCount;
	}
	
	public void addObservation(double observation)
	{
		if (count >= WINDOW)
		{
			sum *= FACTOR;
			sumOfSquares *= FACTOR;
			count *= FACTOR;
		}
		
		sum += observation;
		sumOfSquares += (observation * observation);
		count ++;
	}
	
	public double getMean()
	{
		if (count > 0) return (sum / count);
		else return 0;
	}
	
	public double getStandardDeviation()
	{
		double correctionFactor = (sum * sum) / count;
		return (sumOfSquares - correctionFactor) / (count - 1);
	}
	
	public double getSum()
	{
		return sum;
	}
	
	public double getSumOfSquares()
	{
		return sumOfSquares;
	}
	
	public int getCount()
	{
		return count;
	}
	
	public void setWindow(double someWindow)
	{
		WINDOW = (int) someWindow;
		FACTOR = 1 - (1 / someWindow);
	}
}

