package dy;
import robocode.*;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.util.Utils;

/**
 * LevelOne - a robot by David Yang
 */
public class LevelOne extends AdvancedRobot
{
	private double bearingFromGun;
	private double bearingFromRadar;
	double absoluteBearing;

	private int Direction = 1;
	private int Towards = 1;
	private int Away = -1;
	private int IN_OR_OUT = 1;
	private double ExtraDist;
	
	private double oldEnemyHeading;
	private double EnemyEnergy = 0;
	private int bulletCount = 0;
	private int Turns_ahead = 80;
	private boolean Change_dir = true;
	private boolean Big_Bullet = false;
			
	private double FirePower = 2.5;
	private static String circ = "Circular Gun";
	private static String linear = "Linear Gun";
	private static String Gun = linear;
	private int count1 = 0;
	private int count2 = 0;
	
	private double CircShots = 0;
	private double CircHits = 0;
	private double LinearShots = 0;
	private double LinearHits = 0;
	private double CircHitRate;
	private double LinearHitRate;
	private static int Num_data_rounds;
	private static double AverageCircHit;
	private static double AverageLinearHit;
	private static double[] CircRate;
	private static double[] LinearRate;
	
	/**
	 * What to do when you don't see another robot
	 */
	public void run() {
	
		if(getNumRounds() <= 10){
			Num_data_rounds = 2;
		}
		else if(getNumRounds() <= 50){
			Num_data_rounds = (int)(0.2 * getNumRounds());
		}
		else{
			Num_data_rounds = (int)(0.1 * getNumRounds());
			}
		CircRate = new double[Num_data_rounds];
		LinearRate = new double[Num_data_rounds];
		System.out.println(Num_data_rounds);
		setBodyColor(Color.black);
		setGunColor(Color.red);
		setRadarColor(Color.blue);
		setBulletColor(Color.yellow);
		setScanColor(Color.red);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		while(true) {
			setAhead(100);
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}

	/**
	 * What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
				
		double EnergyDiff = EnemyEnergy - e.getEnergy();
		if(EnergyDiff <= 3.0 && EnergyDiff > 0.0){
			DodgeBullets(e.getDistance());
		}
		EnemyEnergy = e.getEnergy();
		
		movementTechnique(e.getBearing(), e.getDistance());
		AvoidHitWall();
		TrackEnemy(e.getBearing());
		
		Fire(e);
		scan();
	}

	/**
	 * movementTechnique: The way to move around the battlefield
	 */
	public void movementTechnique(double Bearing, double Distance){
			
		if(getEnergy()<20 || Big_Bullet){
			ExtraDist = 150;
		}
		else{
			ExtraDist = 0;
		} 	
			
		if(Distance < 500){
			if(Distance < 250 + ExtraDist){
				IN_OR_OUT = Away;
				setMaxVelocity(8);
			}
			else{
				IN_OR_OUT = Towards;
			}
		
			double rightAngle = 0;
			
			if(Bearing > 0){
				rightAngle = Bearing - 90 + IN_OR_OUT*Direction*30;
			}
			else if(Bearing < 0){
				rightAngle = Bearing + 90 - IN_OR_OUT*Direction*30;		
			}
			setTurnRight(rightAngle);
			setAhead(200 * Direction);
		}
		
		else{
			setTurnRight(Bearing + Direction*20);
			setAhead(200);
		}
	}
	
	/**
	 * AvoidHitWall: Looks ahead in direction of travel by 80 pixels to avoid wall
	 */
	public void AvoidHitWall(){
		
		double Angle = Utils.normalAbsoluteAngle(2*Math.PI - getHeadingRadians() + Math.PI/2);
		
		Point2D.Double myPos = new Point2D.Double(getX() + Turns_ahead * Direction * Math.cos(Angle), getY() +  Turns_ahead * Direction*Math.sin(Angle));
	
		//changes direction when wall detected
		//To prevent from being stuck Change_dir is used to prevent from 
		//changing direction continually when in area where wall is detected
		//So when out of area, Change_dir becomes true again and looks for walls again
		if(myPos.x<18.0 ||myPos.x>getBattleFieldWidth()-18.0){
			if(Change_dir){
			Direction *=-1;
			Change_dir = false;
			}
		}
		else if(myPos.y<18.0 ||myPos.y>getBattleFieldHeight()-18.0){
			if(Change_dir){
			Direction *=-1;
			Change_dir = false;
			}
		}
		else{
			Change_dir = true;
		}
	}
	
				
	/**
	 * TrackEnemy: Locks on to the enemy
	 */
	public void TrackEnemy(double Bearing){

		absoluteBearing = getHeading() + Bearing;
		//bearingFromGun = normalRelativeAngle(absoluteBearing - getGunHeading());
		bearingFromRadar = normalRelativeAngle(absoluteBearing - getRadarHeading());
		setTurnRadarRight(bearingFromRadar);		
	}
	
	/**
	 * Fire: Selects firing method based on first three round statistics
	 */
	public void Fire(ScannedRobotEvent e){

			if(getEnergy()<10){
				FirePower = .5;
			}
		
			if(getRoundNum() < Num_data_rounds){
				if(count1 < 10){
					Gun = linear;
					LinearTargetShot(e.getBearing(), e.getHeading(), e.getDistance(), e.getVelocity(),FirePower);

				}
				else if(count2 < 10){
					Gun = circ;
					CircularTargetShot(e.getBearing(), e.getHeading(), e.getDistance(), e.getVelocity(),FirePower);

				}
				else{
					count1 = 0;
					count2 = 0;
				}	

			}
			else{
				if(e.getEnergy() < 15){
					SprayGun(e);
				}				
				else if(Gun.equals(linear)){
					LinearTargetShot(e.getBearing(), e.getHeading(), e.getDistance(), e.getVelocity(),FirePower);
				}
				else if(Gun.equals(circ)){
					CircularTargetShot(e.getBearing(), e.getHeading(), e.getDistance(), e.getVelocity(),FirePower);
				}
			}
	}		

	/**
	 * onBuletMissed: collects data and adjusts gun
	 */	
	public void onBulletHit(BulletHitEvent e){
		
		if(getRoundNum() < Num_data_rounds){
			if(Gun.equals(circ)){
				CircHits++;
			}
			else if(Gun.equals(linear)){
				LinearHits++;
			}
		}
		else{
			if(FirePower<3.0){
				FirePower = FirePower + 0.1;
			}	
		}
	}

	public void onBulletMissed(BulletMissedEvent event){
		if(FirePower>1.5){
			FirePower = FirePower - 0.1;
		}
	}
	
	public void onHitByBullet(HitByBulletEvent e){
		if(e.getPower()>2.5 && e.getPower()<3.0){
			Big_Bullet = true;
		}
		else{
			Big_Bullet = false;
		}
		setMaxVelocity(8);
	}

	/**
	 * onHitWall: To escape that damn obstacle
	 */	
	public void onHitWall(HitWallEvent e) {
		
		setTurnRight(90);
		setAhead(100);
		execute();
	}
	
	/**
	 * DodgeBullets: To avoid bullets
	 */	
	public void DodgeBullets(double Distance){
		
		if(Distance>300 || Change_dir){
			DodgeTechOne();
		}
		else if(Change_dir){
			DodgeTechTwo();
			bulletCount =0;
			setMaxVelocity(8);
		}
	}	
	
	/**
	* DodgeTechOne: Moves, stops, changes directiona and continues to move
	*/
	public void DodgeTechOne(){
		
		bulletCount++;
				
		if(bulletCount == 3){
			Direction *=-1;
			setMaxVelocity(8);
			bulletCount = 0;
		}
		else if(bulletCount == 1){
			setMaxVelocity(0);
		}
		else{
			setMaxVelocity(8);
		}
	}

	/**
	 * DodgeTechTwo: Dodge by instantly changing direction
	 */
	public void DodgeTechTwo(){
		
		Direction *=-1;
	}
	
	/**
	 * onWin: Do the 'twist dance' on winning
	 */
	public void onWin(WinEvent e){

		if(getRoundNum() < Num_data_rounds){

			CalcHitRate();
			LinearRate[getRoundNum()] = LinearHitRate;
			CircRate[getRoundNum()] = CircHitRate;
			System.out.println("Circular Gun Hit Rate for this round: " + CircHitRate + "%");
			System.out.println("Linear Gun Hit Rate for this round: " + LinearHitRate + "%");
		}
		if(getRoundNum() == Num_data_rounds-1){
			for(int i = 0; i < Num_data_rounds; i ++ ){
				AverageLinearHit += LinearRate[i];
				AverageCircHit += CircRate[i];
			}
				AverageLinearHit = AverageLinearHit/Num_data_rounds;
				AverageCircHit = AverageCircHit/Num_data_rounds;
				chooseBestGun();
				System.out.println("Average Circular Gun Hit Rate: " + AverageCircHit + "%");
				System.out.println("Average Linear Gun Hit Rate: " + AverageLinearHit + "%");
		}
	
		setMaxVelocity(0);
		turnGunRight(22.5);
		turnLeft(22.5);
		
		while(true){
			setTurnLeft(45);
			turnGunRight(45);
			setTurnRight(45);
			turnGunLeft(45);
		}
	}

	public void onDeath(DeathEvent e){
		if(getRoundNum() < Num_data_rounds){
			CalcHitRate();
			LinearRate[getRoundNum()] = LinearHitRate;
			CircRate[getRoundNum()] = CircHitRate;
			System.out.println("Circular Gun Hit Rate for this round: " + CircHitRate + "%");
			System.out.println("Linear Gun Hit Rate for this round: " + LinearHitRate + "%");
		}
		if(getRoundNum() == Num_data_rounds-1){
			for(int i = 0; i < Num_data_rounds; i ++ ){
				AverageLinearHit += LinearRate[i];
				AverageCircHit += CircRate[i];
			}
				AverageLinearHit = AverageLinearHit/Num_data_rounds;
				AverageCircHit = AverageCircHit/Num_data_rounds;
				chooseBestGun();
				System.out.println("Average Circular Gun Hit Rate: " + AverageCircHit + "%");
				System.out.println("Average Linear Gun Hit Rate: " + AverageLinearHit + "%");
		}
	}

	/**
	 * CalcHitRate: Calculate Hit rate of Gun
	 */	
	public void CalcHitRate(){
		
		LinearHitRate = LinearHits/LinearShots*100;
		CircHitRate =  CircHits/CircShots*100;
	}

	/**
	 * chooseBestGun: choosed gun with highest hit rate
	 */	
	public void chooseBestGun(){
		
		if(AverageLinearHit >= AverageCircHit){
			Gun = linear;
		}
		else{
			Gun = circ;
		}
	}

	/**
	 * normalRelativeAngle: Degree version
	 */
	public static double normalRelativeAngle(double angle) {

		if (angle > -180 && angle <= 180) {
			return angle;
		}
		double fixedAngle = angle;
		while (fixedAngle <= -180) {
			fixedAngle += 360;
		}
		while (fixedAngle > 180) {
			fixedAngle -= 360;
		}
		return fixedAngle;
	}	
		
		
	public void SprayGun(ScannedRobotEvent e){
		if(getGunHeat() == 0){
			//bearingFromGun = normalRelativeAngle(absoluteBearing - getGunHeading());
			//setTurnGunRight(bearingFromGun);
			LinearTargetShot(e.getBearing(), e.getHeading(), e.getDistance(), e.getVelocity(),1);
			System.out.println("Fired Spray Gun");
		}	
	}
				
	/**
	 * LinearTargetShot: Predicts and shoots at targets moving in straight line
	 */
	public void LinearTargetShot(double Bearing, double Heading, double eDistance, double eVelocity, double bulletPower){
		
		double eBearing = Math.toRadians(Bearing);
		double eHeading = Math.toRadians(Heading);

		Point2D.Double myPos = new Point2D.Double(getX(), getY());
		Point2D.Double enemyPos = project(myPos, getHeadingRadians() + eBearing, eDistance);
				
		double TimeDiff = 1;
		
		Point2D.Double predicted = (Point2D.Double) enemyPos.clone();
		
		while(TimeDiff * (20.0 - 3.0 * bulletPower) < myPos.distance(predicted)){		
			TimeDiff++;
			predicted = project(predicted, eHeading, eVelocity);
			
			predicted.x = Math.min(Math.max(18.0, predicted.x), getBattleFieldWidth() - 18.0);	
			predicted.y = Math.min(Math.max(18.0, predicted.y), getBattleFieldHeight() - 18.0);
		}

		setTurnGunRightRadians(Utils.normalRelativeAngle(angle(myPos, predicted) - getGunHeadingRadians()));
		if(getGunHeat() == 0){
			setFire(bulletPower);
			LinearShots ++;
			System.out.println("Fired " + Gun);
			count1++;
		}
	}
	/**
	 * CircularTargetShot: Predicts and shoots at targets moving in a circular path
	 */
	public void CircularTargetShot(double Bearing, double Heading, double eDistance, double eVelocity, double bulletPower){
		

		double eBearing = Math.toRadians(Bearing);
		double eHeading = Math.toRadians(Heading);
		double newEnemyHeading = Utils.normalAbsoluteAngle(eHeading);
		double EnemyHeadingDiff = Utils.normalRelativeAngle(newEnemyHeading - oldEnemyHeading);
		
		oldEnemyHeading = newEnemyHeading;
		
		Point2D.Double myPos = new Point2D.Double(getX(), getY());
		Point2D.Double enemyPos = project(myPos, getHeadingRadians() + eBearing, eDistance);
		
		double TimeDiff = 1;

		Point2D.Double predicted = (Point2D.Double) enemyPos.clone();
		double predictedHeading = newEnemyHeading;
		
		if(EnemyHeadingDiff > 0.0001){ 
			while(TimeDiff * (20.0 - 3.0 * bulletPower) < myPos.distance(predicted)){		
			
				TimeDiff++;
				predictedHeading += EnemyHeadingDiff;
			
				Point2D.Double newPredicted = project(predicted, predictedHeading, eVelocity);
				newPredicted.x = Math.min(Math.max(18.0, newPredicted.x), getBattleFieldWidth() - 18.0);	
				newPredicted.y = Math.min(Math.max(18.0, newPredicted.y), getBattleFieldHeight() - 18.0);

				predicted = newPredicted;	
			}
		}
		
		setTurnGunRightRadians(Utils.normalRelativeAngle(angle(myPos, predicted) - getGunHeadingRadians()));
		if(getGunHeat() == 0){
			setFire(bulletPower);
			CircShots ++;
			System.out.println("Fired " + Gun);
			count2++;
		}

		
	}
	
	/**
	 * project: projects the targets future position
	 */
	public static Point2D.Double project(Point2D.Double origin, double angle, double distance){
		return new Point2D.Double(origin.x + distance * Math.sin(angle), origin.y + distance * Math.cos(angle));
	}

	/**
	 * angle: returns the angle of a coordinate from my coordinate
	 */
	public static double angle(Point2D.Double origin, Point2D.Double destination){
		return Utils.normalAbsoluteAngle(Math.atan2(destination.x - origin.x, destination.y - origin.y));
	}
}