package sul;
import robocode.*;
import robocode.util.*;
import java.awt.Color;
import java.awt.geom.*;

// BlueBot - a robot by (Sulibilune)
// My first bot with StopAndGo movement, credit to Grinnik0.6 from Griezel.
// Head-ON Targeting.
// Size: 249 bytes.

public class BlueBot extends AdvancedRobot
{
	static double dist = 48;
	static double enemyLastEnergy;
	static Rectangle2D.Double fireField = new Rectangle2D.Double(20,20,762,562);
	
	public void run() {
			while(true) {turnRadarRightRadians(Double.POSITIVE_INFINITY);}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double enemyAbsBearing = getHeadingRadians() + e.getBearingRadians();
		
		//TARGETING
		setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsBearing - getGunHeadingRadians()));
		setFire(2);
		
		//RADAR
		setTurnRadarLeft(getRadarTurnRemaining());
		
		//MOVEMENT
		if ( enemyLastEnergy - (enemyLastEnergy = e.getEnergy()) > 0.0) {setAhead(dist); }
		
		double myDirection = (dist /Math.abs(dist));
		double adjustAngle;
		double prefAngle = adjustAngle = enemyAbsBearing + 1.570796327 - ((e.getDistance() / 420) - 1.0) * 1.570796327 * (myDirection);
		while( !fireField.contains( getX() + (dist * Math.sin(adjustAngle -= (0.05*myDirection))),getY() + (dist * Math.cos(adjustAngle -= (0.05*myDirection)))));
		
		if (Math.abs((adjustAngle - prefAngle)) > 1.427996661) {
			setAhead( dist *= -1);
		}
		setTurnRightRadians( Utils.normalRelativeAngle( adjustAngle - getHeadingRadians()));
	}
}
