package madmath;
import robocode.*;
//import java.awt.Color;

/**
 * Cow - a robot by (MadMath)
 */
public class Cow extends AdvancedRobot
{
	//variables for walls
	boolean peek; // Don't turn if there's a robot there
	double moveAmount; // How much to move
	boolean crowd =true;	
	//variables for data
	boolean match = false;
	int len=5;
	int matchnum = 0;
	int matchlen = 0;
	//variables for targeting
	double targetDis;
	String targetName="null";
	boolean target=false;
	double gunTurnAmt; // How much to turn our gun when searching
	double motionComp = 0;
	double prevHeading=0;
	double newHeading = 0;


	    String [] robo1 = {"dead","0","0","0","0"};
        String [] robo2 = {"dead","0","0","0","0"};
        String [] robo3 = {"dead","0","0","0","0"};
        String [] robo4 = {"dead","0","0","0","0"};
        String [] robo5 = {"dead","0","0","0","0"};
		String enemies [][]= {robo1,robo2,robo3,robo4,robo5};
	/**
	 * run: Cow's default behavior
	 */
	public void run() {
		if (getOthers()<6){
			crowd=false;
			setAdjustGunForRobotTurn(true);
			setAdjustRadarForGunTurn(true);
		}
		if (crowd==true){
			//Walls
			// Initialize moveAmount to the maximum possible for this battlefield.
			moveAmount = Math.max(getBattleFieldWidth(), getBattleFieldHeight());
			// Initialize peek to false
			peek = false;
		
			// turnLeft to face a wall.
			// getHeading() % 90 means the remainder of 
			// getHeading() divided by 90.
			turnLeft(getHeading() % 90);
			ahead(moveAmount);
			// Turn the gun to turn right 90 degrees.
			peek = true;
			turnGunRight(90);
			turnRight(90);
		}

		while(true) {

			if (crowd==true){
				// Look before we turn when ahead() completes.
				peek = true;
				// Move up the wall
				ahead(moveAmount);
				// Don't look now
				peek = false;
				// Turn to the next wall
				turnRight(90);

			}
			
			
			if (crowd == false){
				setTurnRadarRight(720);
				run2();
				execute();
			}
		}
	}

	/**
	 * onHitRobot:  Move away a bit.
	 */	
	public void onHitRobot(HitRobotEvent e) {
		if (crowd==true){
			// If he's in front of us, set back up a bit.
			if (e.getBearing() > -90 && e.getBearing() < 90) {
				back(100);
			} // else he's in back of us, so set ahead a bit.
			else {
				ahead(100);
			}
		}
	}
	public void onHitWall (HitWallEvent e) {
		if (crowd!=true){
			double bfw = getBattleFieldWidth();
			double bfh = getBattleFieldHeight();
			turnRight(90-getHeading());
			ahead(bfw/2-getX());
			turnRight(0-getHeading());
			ahead(bfh/2-getY());
		}
	}

	public void run2() {
		setAhead(10);
		setTurnRight(4);

		for (int i=0; i<len; i++){
			if (targetName==enemies[i][0]){
				target=true;
				//double sideDist = Math.sqrt(Math.pow(Double.parseDouble(enemies[i][2]),2)+Math.pow(4,2)-2*Double.parseDouble(enemies[i][2])*4*Math.cos(Math.toRadians(Double.parseDouble(enemies[i][3]))));
				//double motion = Math.toDegrees(Math.asin(4*Math.sin(Math.toRadians(Double.parseDouble(enemies[i][3]))/sideDist)));
				while (gunTurnAmt+5<normalRelativeAngle((Double.parseDouble(enemies[i][3]) + (getHeading() - getGunHeading())))||gunTurnAmt-5>normalRelativeAngle((Double.parseDouble(enemies[i][3]) + (getHeading() - getGunHeading())))){
					setTurnRadarRight(360);
					scan();
					newHeading = Double.parseDouble(enemies[i][1]) - prevHeading;
					setAhead(10);
					setTurnRight(4);
					gunTurnAmt = normalRelativeAngle((Double.parseDouble(enemies[i][3]) + (getHeading() - getGunHeading())));
					out.println (motionComp);
					
					if (Double.parseDouble(enemies[i][4])>4){
						motionComp = Math.sin(Math.toRadians(Double.parseDouble(enemies[i][3])+180+getHeading()-Double.parseDouble(enemies[i][1])));
						motionComp=motionComp * 5 * Double.parseDouble(enemies[i][4]);
					}
					else if (Double.parseDouble(enemies[i][4])<4) {
						motionComp=0;					
					}
					setTurnGunRight(gunTurnAmt-5); // Try changing these to setTurnGunRight,
					execute();
				}
				if (newHeading<45){
					turnGunRight(motionComp);
				}
				fire(3);
				break;				
			}
			else if (targetName!=enemies[i][0]){
				target=false;
			}

		}
		if (target==false){
			selectTarget();
		}
			
	}
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180) {
			return angle;
		}
		double fixedAngle = angle;

		while (fixedAngle <= -180) {
			fixedAngle += 360;
		}
		while (fixedAngle > 180) {
			fixedAngle -= 360;
		}
		return fixedAngle;
	}		
	public void selectTarget(){
		for (int i=0; i<len; i++){
			if (enemies [i][0] != "dead"){
				targetName=enemies[i][0];
				targetDis=Double.parseDouble(enemies[i][2]);
				break;				
			}

		}
		for (int i=0; i<len; i++){
			if (targetDis>Double.parseDouble(enemies [i][2])){
				if (enemies [i][0] != "dead"){
					targetName=enemies[i][0];
					targetDis=Double.parseDouble(enemies[i][2]);	
				}
			}
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {



		for (int i=0; i<len; i++){
			if (enemies [i][0]== e.getName()){
				match=true;
				matchnum=i;
				break;
			}
			else if (enemies [i][0] != e.getName()){
				match=false;
								
			}

		}
		
		if (match==false){
		
			enemies [matchlen][0]=(e.getName());
			enemies [matchlen][1]= Double.toString(e.getHeading());
			enemies [matchlen][2]= Double.toString(e.getDistance());
			enemies [matchlen][3]= Double.toString(e.getBearing());
			enemies [matchlen][4]= Double.toString(e.getVelocity());
			
			matchlen=matchlen+1;
			if(matchlen>4){
			matchlen=0;
			}
		}
		if (match==true){
			prevHeading = Double.parseDouble(enemies[matchnum][1]);
			enemies [matchnum][1]= Double.toString(e.getHeading());
			enemies [matchnum][2]= Double.toString(e.getDistance());
			enemies [matchnum][3]= Double.toString(e.getBearing());
			enemies [matchnum][4]= Double.toString(e.getVelocity());

		}
		if (crowd==true){
		fire(3);	
		}
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//turnLeft(90 - e.getBearing());
	}
	public void onRobotDeath(RobotDeathEvent e){
		for (int i=0; i<len; i++){
			if (enemies [i][0]== e.getName()){
				enemies [i][0] = "dead";
				break;
			}
		}
		if (getOthers()<6){
			setAdjustGunForRobotTurn(true);
			setAdjustRadarForGunTurn(true);
			crowd=false;
			double bfw = getBattleFieldWidth();
			double bfh = getBattleFieldHeight();
			turnRight(90-getHeading());
			ahead(bfw/2-getX());
			turnRight(0-getHeading());
			ahead(bfh/2-getY());
		}		
	}
}
