package lucasslf.wavesurfing.buffer;

import lucasslf.wavesurfing.EnemyWave;
import lucasslf.wavesurfing.BasicWaveSurfer;

public class SurfBufferD extends SurfBuffer {
	
	private static double[][][] surfStats = new double[BasicWaveSurfer.SEG_BULLET_POWER][BasicWaveSurfer.SEG_DISTANCE][BasicWaveSurfer.BINS];
	public SurfBufferD(int weight) {
		super(weight);
	}

	public void setSegmentationOn(EnemyWave wave){
		wave.addSegmentedBuffer(getSegmentedBuffer(wave.getSegBulletPower(),wave.getSegInitialDistance()));
	}
	
	@Override
	public SegmentedBuffer getSegmentedBuffer(int... args) {
		if(args == null || args.length != 2)
			throw new IllegalArgumentException("args length must be 2");
		return new SegmentedBuffer(surfStats[args[0]][args[1]], this.getWeight());
	}
}
