package amk.ShizzleStiX;
import java.util.*;
import robocode.Bullet;
import java.awt.geom.Point2D;

class Battlefield
{
	ArrayList enemies = new ArrayList();
	ArrayList teammates = new ArrayList();
	ArrayList bullets = new ArrayList();
	
	double width;
	double height;
	
	void setWidth(double w) {
		width = w;
	}
	
	void setHeight(double h) {
		height = h;
	}
	
	double getWidth() {
		return width;
	}
	
	double getHeight() {
		return height;
	}
	
	void addEnemy(FieldUnit unit) {
		int index = getIndexByName(enemies,unit.getName());
		if(index == -1) {
			enemies.add(unit);
		} else {
			enemies.set(index,unit);
		}
	}
	void addTeammate(FieldUnit unit) {
		int index = getIndexByName(teammates,unit.getName());
		if(index == -1) {
			teammates.add(unit);
		} else {
			teammates.set(index,unit);
		}
	}
	void addBullet(Bullet bullet) { bullets.add(bullet); }
	
	void deleteEnemy(String name) {
		int index = getIndexByName(enemies, name);
		if(index != -1) {
			enemies.remove(index);
		}
	}
	
	void deleteTeammate(String name) {
		int index = getIndexByName(teammates, name);
		if(index != -1) {
			teammates.remove(index);
		}
	}
	
	FieldUnit getEnemy(String name) { 
		int index = getIndexByName(enemies, name);
		if(index == -1) { return null; }
		FieldUnit unit = (FieldUnit)enemies.get(index);
		return unit;
	}
	FieldUnit getTeammate(String name) {
		int index = getIndexByName(teammates, name);
		if(index == -1) { return null; }
		FieldUnit unit = (FieldUnit)teammates.get(index);
		return unit;
	}
	
	FieldUnit getWeakestEnemy() {
		Iterator it = enemies.iterator();
		FieldUnit weakest = null;
		while(it.hasNext()) {
			FieldUnit unit = (FieldUnit)it.next();
			if(weakest == null) { weakest = unit; }
			if(unit.getEnergy() < weakest.getEnergy()) { weakest = unit; }
		}
		return weakest;
	}      
	
	FieldUnit getWeakestTeammate() {
		Iterator it = teammates.iterator();
		FieldUnit weakest = null;
		while(it.hasNext()) {
			FieldUnit unit = (FieldUnit)it.next();
			if(weakest == null) { weakest = unit; }
			if(unit.getEnergy() < weakest.getEnergy()) { weakest = unit; }
		}
		return weakest;
	}
	
	FieldUnit getClosestEnemy() {
		Iterator it = enemies.iterator();
		FieldUnit closest = null;
		while(it.hasNext()) {
			FieldUnit unit = (FieldUnit)it.next();
			if(closest == null) { closest = unit; }
			if(unit.getDistance() < closest.getDistance()) { closest = unit; }
		}
		return closest;
	}
	FieldUnit getClosestTeammate() {
		Iterator it = enemies.iterator();
		FieldUnit closest = null;
		while(it.hasNext()) {
			FieldUnit unit = (FieldUnit)it.next();
			if(closest == null) { closest = unit; }
			if(unit.getDistance() < closest.getDistance()) { closest = unit; }
		}
		return closest;
	}
	
	FieldUnit getBestEnemy() {
		Iterator it = enemies.iterator();
		FieldUnit best = null;
		while(it.hasNext()) {
			FieldUnit unit = (FieldUnit)it.next();
			double killfactor = (unit.getDistance()*0.2) % (unit.getEnergy()*0.8);
			unit.setKillFactor(killfactor);
			if(best == null) { best = unit; }
			else if(best.getKillFactor() > unit.getKillFactor()) { best = unit; }
		}
		return best;
	}
	
	int getIndexByName(ArrayList list, String name) {
		Iterator it = list.iterator();
		int index = -1;
		while(it.hasNext()) {
			FieldUnit unit = (FieldUnit)it.next();
			if(name == unit.getName()) {
				index = list.indexOf(unit);
			}
		}
		return index;		
	}
}
