/* This is the weapons module for the StiX Modular Robot System
 * This class handles all gun management for the robot, and it easily
 * modified for any gun system or virtual gun syste, you want.
 */
package amk.ShizzleStiX;
import robocode.*;
import java.awt.geom.Point2D;
import robocode.util.Utils;

class Weaponry extends Module
{
	FieldUnit target = null;
	double firePower = 3.0;
	
	/* The standard constructor */
	public Weaponry(ShizzleStiX bot) {
		this.bot = bot;
		bot.setAdjustGunForRobotTurn(true);
	}
	
	public void run() {
		if(target == null) {
			target = bot.Sensors.field.getBestEnemy();
		}
		if((bot.getTime() - target.getCreationTime()) >=2) {
			target = bot.Sensors.field.getBestEnemy();
		}
		
		if(target != null) {
			long time = bot.getTime() + (int)(target.getDistance()/(20-(3*firePower)));
			double gunOffset = bot.getGunHeadingRadians() - StiXUtil.absoluteBearing(bot.getX(),bot.getY(),target.guessX(time),target.guessY(time));
			bot.setTurnGunLeftRadians(StiXUtil.NormalizeBearing(gunOffset));

			double bulletPower = Math.min(firePower,bot.getEnergy());
			double myX = bot.getX();
			double myY = bot.getY();
			double absoluteBearing = bot.getHeadingRadians() + target.getBearingRadians();
			double enemyX = myX + target.getDistance() * Math.sin(absoluteBearing);
			double enemyY = myY + target.getDistance() * Math.cos(absoluteBearing);
			double enemyHeading = target.getHeadingRadians();
			double enemyVelocity = target.getSpeed();
			
			
			double deltaTime = 0;
			double battleFieldHeight = bot.getBattleFieldHeight(), battleFieldWidth = bot.getBattleFieldWidth();
			double predictedX = enemyX, predictedY = enemyY;
			while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
				predictedX += Math.sin(enemyHeading) * enemyVelocity;	
				predictedY += Math.cos(enemyHeading) * enemyVelocity;
				if(	predictedX < 18.0 
					|| predictedY < 18.0
					|| predictedX > battleFieldWidth - 18.0
					|| predictedY > battleFieldHeight - 18.0){
					predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
					predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
					break;
				}
			}
			double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - myX, predictedY - myY));
			
			bot.setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - bot.getRadarHeadingRadians()));
			bot.setTurnGunRightRadians(Utils.normalRelativeAngle(theta - bot.getGunHeadingRadians()));
			bot.setFire(bulletPower);
			bot.setFire(bulletPower);
		}
	}
	

}
