package dam;

import java.util.*;
import java.io.*;

public class TargetList implements Serializable
{
	private Vector targets = new Vector();
	
	public TargetList(){}
	
	public void add(Target t)
	{
		if(!targets.contains(t)) targets.add(t);
	}
	
	public Target get(int i){ return (Target)targets.elementAt(i); }
	
	public Target get(String targetName)
	{
		for(int i = 0; i < targets.size(); i++)
		{
			if(get(i).nameEquals(targetName)) return get(i);
		}
		return null;
	}
	
	public boolean contains(String targetName)
	{
		return get(targetName) != null;
	}
	
	public void remove(String targetName)
	{
		Target t = get(targetName);
		if(t != null) targets.remove(t);
	}
	
	public int size(){ return targets.size(); }
	
	
	public Enumeration elements(){ return targets.elements(); }
	
	public void remove(Target o){ targets.removeElement(o); }
	
}