package tm;

import java.awt.*;

/********************************************************************
* EnemyMoveAnalyzer4Melee.java -- G4
*                            MogBot ̃p^[}b`O
*                            G heading change, velocity ̗ƁC
*                            ݂Ԃ̉ߋ̓Ƃ}b`OD
*                            
* Date:		2002/Dec/05
*			2003/Jan/05
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
public class EnemyMoveAnalyzer4Melee {
	EnemyHistory4Melee ehism;
	double rotationRad;
	double fW, fH;
	
	//------------------------------------------------------------------
	// constructor
	//
	//
	//------------------------------------------------------------------
	public EnemyMoveAnalyzer4Melee(EnemyHistory4Melee ehism, MyRobot my) {
		this.ehism = ehism;
		this.fW = my.fW;
		this.fH = my.fH;
	}
	
	//------------------------------------------------------------------
	// getPredictedEnemyPoint4() -- ߋ̗ƁC}b`OsC
	//                              bulletTime̓IʒuԂ
	//
	// F	bulletTIme -- CeB
	//			eneGoHeading -- current enemy go heading
	//			absoluteBearing -- current absolute enemy bearing
	//
	// ߂lF	݂̓Gʒu_ƂƂ́Ct̗\zʒu
	//------------------------------------------------------------------
	Point getPredictedEnemyPoint4(int bulletTime, double eneHeading, long currTime, double bulletVelocity, double eneX, double eneY, double myX, double myY, String eneName) {
		int i, j;
		double dx, dy;
		double dx2, dy2;				//ړ̍W
		final int TIME_W = 7;			//}b`OɎgturn
		
		EnemyHistory4 ehis = ehism.getEnemyHistory(eneName);
		if (ehis == null) return null;

		int count = 0;
		double[] dheadHis = new double[TIME_W];
		double[] veloHis = new double[TIME_W];
		long lastTime = currTime - TIME_W + 1;
		int idx = (ehis.size + ehis.endIndex - TIME_W + 1) % ehis.size;
		
		if (ehis.startIndex == 0 && ehis.endIndex - ehis.startIndex < TIME_W + bulletTime + 10) return null;			// TIME_W Ԃ񖳂
		

		//݂ߋ TIME_W Ԃ̓GdheadHis[]Ɋi[
		for (i = 0; i < TIME_W; i++) {
			dheadHis[i] = ehis.diffHeading[idx];
			veloHis[i] = ehis.velocity[idx];
			idx = (idx + 1) % ehis.size;
		}
		
		
		//}b`O
		int startIdx = 0, minIdx = 0;
		double diffValue;
		double minR = 9E10;
		boolean matchDone = false;
		int afterTWidx = 0;				//TIME_W idx
		double sumDDH, sumDV, aveDDH, aveDV;
				
		for (i = 0; i < ehis.dataSize - bulletTime - TIME_W - 4; i++) {
			idx = (ehis.startIndex + i) % ehis.size;
			startIdx = idx;
			
			if (ehis.time[idx] > ehis.time[(idx + TIME_W + bulletTime + 10) % ehis.size]) {
				//Ԃ time=0 L
//				M.print("Fine time=0!! Skip");
				continue;	
			}
			
			sumDDH = sumDV = 0;
			for (j = 0; j < TIME_W; j++) {
				sumDDH += Math.abs(dheadHis[j] - ehis.diffHeading[idx]);
				sumDV += Math.abs(veloHis[j] - ehis.velocity[idx]);
				idx = (idx + 1) % ehis.size;
			}
			aveDDH = sumDDH / TIME_W;
			aveDV = sumDV / TIME_W;
			diffValue = aveDDH / 20 + aveDV / 16;


			matchDone = true;

			if (minR >= diffValue) {
				minR = diffValue;
				minIdx = startIdx;
				afterTWidx = idx;
			}
		}

		if (!matchDone) return null;

		//}b`OCbulletTimëʒu擾
		long predTime = ehis.time[minIdx] + TIME_W + bulletTime - 1;
		idx = afterTWidx;
		double predHeading = eneHeading;
		double predX = 0, predY = 0;
		count = 0;
		double rad;
		while (ehis.time[idx] <= predTime && count <= bulletTime) {
			predHeading = (predHeading + ehis.diffHeading[idx]) % 360;
			rad = Math.toRadians(90 - predHeading);
			predX += Math.cos(rad) * ehis.velocity[idx];
			predY += Math.sin(rad) * ehis.velocity[idx];
			idx = (idx + 1) % ehis.size;
			count++;
		}
		


		//G\ʒuɊÂ bulletTime ČvZ
		double epX, epY;
		double distance;
		
		for (i = 0; i < 4; i++) {
			epX = eneX + predX;
			epY = eneY + predY;

			if (epX < 20)           epX = 20;
			else if (epX > fW - 20) epX = fW - 20;
			if (epY < 20)           epY = 20;
			else if (epY > fH - 20) epY = fH - 20;
	
			dx = myX - epX;
			dy = myY - epY;
		
			distance = Math.sqrt(dx*dx + dy*dy);
			bulletTime = (int)(distance / bulletVelocity);

			if (ehis.time[(afterTWidx + bulletTime) % ehis.size] < ehis.time[afterTWidx]) {
				//Ԃ time=0 
				return null;
			}

			predTime = ehis.time[minIdx] + TIME_W + bulletTime - 1;
			count = 0;
			idx = afterTWidx;
			predHeading = eneHeading;
			predX = predY = 0;
			while (ehis.time[idx] <= predTime && count <= bulletTime) {
				predHeading = (predHeading + ehis.diffHeading[idx]) % 360;
				rad = Math.toRadians(90 - predHeading);
				predX += Math.cos(rad) * ehis.velocity[idx];
				predY += Math.sin(rad) * ehis.velocity[idx];
				idx = (idx + 1) % ehis.size;
				count++;
			}
		}
		
		return new Point(predX, predY);		
	}
}