package tm;
import robocode.*;
import java.util.*;

/********************************************************************
* Move1on1Crazy.java -- for 1 on 1
*                       _
*                         
*
* Date:		2002/Dec/14
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
class Move1on1Crazy implements Move {
	MyRobot my;
	double fW, fH;
	double dstX, dstY;
	Random rand = new Random(System.currentTimeMillis());
	Random randStop = new Random(System.currentTimeMillis());
	Random randSpeed = new Random(System.currentTimeMillis());
	Random randDir = new Random(System.currentTimeMillis());
	FieldMap map;
	
	int dirIndex = 0;
	int dir = 1;
	int stopCount = 0;
	final int D1, D2;			//ړpxˑ鋗
	
	//---------------------------------------------------------
	// constructor
	//
	//
	//---------------------------------------------------------
	public Move1on1Crazy(MyRobot my) {
		this.my = my;
		fW = my.fW;
		fH = my.fH;
		map = my.map;
		D1 = (int)(fW * 0.5);
		D2 = (int)(fW * 0.875);
		init();
	}
	
	public void init() {
		dstX = my.getX();
		dstY = my.getY();
		my.EPSILON = 50;
	}
	
	public double getDstX() {
		return dstX;
	}
	
	public double getDstY() {
		return dstY;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setNextPoint() {
		Enemy ene = map.getNearestEnemy(my.getTime());

		if (ene == null) return;
		
		double angle;				//[_[]px
		double absoluteBearing;		//Gʒu̐Ίpx
		double bearing, distance;
		
		bearing = ene.getBearing();
		distance = ene.getDistance();

		absoluteBearing = M.angleUnder180(bearing + my.getHeading());
		
		//Gڋ߁CH
		if (distance < 150) {
			noliMeTangere(absoluteBearing);
			return;
		}
			
			
		
		if (my.isArrived(dstX, dstY)) {
			angle = rand.nextInt(160) - 80 + my.getHeading();
			if (dir > 0) {
				angle = M.angleUnder180(angle);	
			} else {
				angle = M.angleUnder180(angle + 180);
			}
			Point po = M.degree2point(angle, 100);

			if (randDir.nextInt(5) == 0) dir *= -1;
				
			dstX = my.getX() + po.x;
			dstY = my.getY() + po.y;
			
			//go center
			double cdx, cdy;
			cdx = fW / 2 - dstX;
			cdy = fH / 2 - dstY;
			
			dstX += cdx / 8;
			dstY += cdy / 10;

			correctDestination();
		}
		
		//speed
		my.setMaxVelocity(randSpeed.nextInt(2) + 7);

		my.setGoPos(dstX, dstY);
	}


	//------------------------------------------------------------------
	// noliMeTangere() -- mEE^Q
	//                    ɐG
	//                    GڋߎCs
	//------------------------------------------------------------------
	void noliMeTangere(double absoluteBearing) {
		double goAngle1, goAngle2;
		double dx, dy;
		double d1, d2;
			
		my.setMaxVelocity(8);
			
		double minx, miny, min;		//ǂւ̍ŒZ
		minx = Math.min(my.getX(), fW - my.getX());
		miny = Math.min(my.getY(), fH - my.getY());
		min = Math.min(minx, miny);
			
		
		//ǂɋ߂H
		if (min < 100 && my.isArrived(dstX, dstY)) {
			//Eւ̊pxZo
			goAngle1 = absoluteBearing + 100;
			goAngle2 = absoluteBearing - 100;
			Point po1 = M.degree2point(goAngle1, 80);
			Point po2 = M.degree2point(goAngle2, 80);
		
			//Eǂ炪S֋߂
			dx = fW / 2 - (my.getX() + po1.x);
			dy = fH / 2 - (my.getY() + po1.y);
			d1 = dx*dx + dy*dy;
			
			dx = fW / 2 - (my.getX() + po2.x);
			dy = fH / 2 - (my.getY() + po2.y);
			d2 = dx*dx + dy*dy;
		
			//S֋߂ֈړ
			if (d1 < d2) {
				dstX = my.getX() + po1.x;
				dstY = my.getY() + po1.y;				
			} else {
				dstX = my.getX() + po2.x;
				dstY = my.getY() + po2.y;
			}
		} else {
			//ǂɋ߂ȂƂ
			goAngle1 = absoluteBearing + 120;
			Point po1 = M.degree2point(goAngle1, 80);
			dstX = my.getX() + po1.x;
			dstY = my.getY() + po1.y;
		}
		
		correctDestination();
		my.setGoPos(dstX, dstY);

		return;
	}
	
				
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setMove() {
		//setNextPos() ֈڂ
		;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void wallNear() {
		;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void hitByBullet(HitByBulletEvent e) {		
		my.result.damage();
		my.selecter.damage(e.getPower());
	}
	
	//--------------------------------------------------------------
	// correctDestination() -- dstX, dstY tB[h̒lɂ
	//
	//------------------------------------------------------------
	private void correctDestination() {
		final double MARGIN = 100;
		final double REF = 1.0;		//45̓ˊpŔ]
		boolean out = false;
		double dx, dy;
		double slope;
		
		dx = dstX - my.getX();
		dy = dstY - my.getY();
		
		if (dx != 0) slope = dy / dx;
		else slope = 9999999;
		
		if (dstX < MARGIN) {
			dstX = MARGIN;
			//out = true;
			if (slope > -REF || slope < REF) dir *= -1;
			else my.setMaxVelocity(4);
		} else if (fW - dstX < MARGIN) {
		 	dstX = fW - MARGIN;
		 	//out = true;
			if (slope > -REF || slope < REF) dir *= -1;
			else my.setMaxVelocity(4);
		}
		if (dstY < MARGIN) {
			dstY = MARGIN;
			//out = true;
			if (slope > 1.0 / REF || slope < -1.0 / REF) dir *= -1;
			else my.setMaxVelocity(4);
		} else  if (fH - dstY < MARGIN) {
			dstY = fH - MARGIN;
			//out = true;
			if (slope > 1.0 / REF || slope < -1.0 / REF) dir *= -1;
			else my.setMaxVelocity(4);
		}
	}
	
	//------------------------------------------------------------------
	// scannedRobot()
	//
	//
	//------------------------------------------------------------------
	public void scannedRobot(ScannedRobotEvent e) {
		my.map.put(e, my.getHeading(), my.getTime(), my.getX(), my.getY());
		
		double x, y;
		double absoluteBearing = (360 + e.getBearing() + my.getHeading() ) % 360;
		x = my.getX() + Math.cos(Math.toRadians(90-absoluteBearing)) * e.getDistance();
		y = my.getY() + Math.sin(Math.toRadians(90-absoluteBearing)) * e.getDistance();
		
		my.robotKKZ.gun.put(x, y, e.getDistance(), e.getVelocity(), e.getHeading(), absoluteBearing, my.getTime());
	}
}