package tobe.mini;

/**
 * MiniVector - for doing calculations
 * This is like a polar vector, except sin and cos are switched.
 * It has a point of origin, a distance and a bearing
 * @author  tobe
 */
public class MicroVector {

	double r = 1;
	double theta = 0;
	double origoX = 0;
	double origoY = 0;
        
	void setPolar(double bearing, double distance, double x, double y) {
		r = distance;
		theta = bearing;
		setOrigin(x,y);
	}
	
        /** sets the vector as the difference between two points.
         * The first is where you go to, the second where you start,
         * think of a mail To: followed by From:
         */
	void setPoints(double toX, double toY, double fromX, double fromY) {
		if(toX == fromX && toY == fromY) {
			setPolar(0,0,fromX,fromY);
		} else {
			double dx = toX-fromX;
			double dy = toY-fromY;
			setPolar(Math.atan2(dx, dy), Math.sqrt(dx*dx+dy*dy), fromX, fromY);
		}
	}

	/** set origin (translates the whole vector) */
	public void setOrigin(double x, double y) {
		origoX = x;
		origoY = y;
	}
        
	double getToX() { return origoX+r*Math.sin(theta); }
	double getToY() { return origoY+r*Math.cos(theta); }

        /** point to same point, but from a different origin */
        public void changeOrigin(double fromX, double fromY) {
            setPoints(getToX(), getToY(), fromX, fromY);
        }
        
        /** sets this vector to point to the point reached by
         * moving from the endpoint of this vector
         * distance along bearing
         */
        public void add(double bearing, double distance) {
            double x = origoX;
            double y = origoY;
			setPolar(bearing, distance, getToX(), getToY());
            changeOrigin(x, y);
        }
        
        /** Utility routine to take an angle in radians and returns its normal value between -PI and PI*/
	static double normalizeAngle(double a) {
		return Math.atan2(Math.sin(a), Math.cos(a));
		//return (7*Math.PI + a) % (2*Math.PI) - Math.PI;
	}
    
}
