package myl.nano;
import robocode.*;

/**
 * Graviton - a particle at codesize 248 by Martin Y Lepsoy (DrLoco)
 * email: mlepsoy@yahoo.no
 *
 *
   *-Features-*
 * 
 * - Anti-gravity movement
 * - Spinning radar
 * - Target lock between shots on closest target
 * - Direct hit gun (no special)
 *
 *
   *-Open source-*
 * 
 * This bot is open source. Feel free to make use of my code as long as you
 * - Don't just copy-paste the code (I don't want to fight modified versions of my own bot)
 * - Make your bot open source
 * - And preferably give credit;-)
 *
 * If you want to use whole snippets or want to discuss the code,
 * send me an email and it will be totally alright. Just let me know;)
 *
 *
   *-Version history-*
 *
 * 05.01.2003 - Version 1.10 - codesize 249
 *
 * Added a small gravity force in our tank's heading to make it drive a little more, instead of just circling around a point with high gravity
 * Reduced codesize on targetlock, at the expence of being able to track multiple targets at once
 * Power saving when few enemies
 *
 *
 * 01.01.2003 - Version 1.01 - codesize 248 (Happy new year!)
 *
 * changed some constants related to anti-gravity force
 *
 *
 * 31.12.2002 - Version 1.00 - codesize 248
 * - Anti-gravity movement
 * - Spinning radar
 * - Target lock between shots on closest target
 * - Direct hit gun (no special)
 *
 * 
   *-Special thanks-*
 *
 * I would like to thank
 * - Vuen, David Alves and Michael Dorgan for ideas on tiny anti-gravity code that fits in nano bots;)
 * - and to all other robocoders in this great community
 */
public class Graviton extends AdvancedRobot
{
	static double	trackingTargetDistance;	//distance to target we are tracking(distance to closest target)
	static double	forceX;					//x force made by enemy robots
	static double	forceY;					//y force made by enemy robots
	
	public void run() {
		setAdjustGunForRobotTurn( true );
		setTurnRadarRightRadians( trackingTargetDistance = Double.POSITIVE_INFINITY );
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double targetBearing;
		double targetDistance;
		double ourHeading;
		double others = getOthers();
		//calculate force from robots
		forceX = forceX * 0.87 - ( Math.sin( targetBearing = e.getBearingRadians() + ( ourHeading = getHeadingRadians() ) ) - Math.sin( ourHeading ) / others ) / ( targetDistance = e.getDistance() );
		forceY = forceY * 0.87 - ( Math.cos( targetBearing ) - Math.cos( ourHeading ) / others ) / targetDistance;
		//aim at target if may be the one we are currently tracking ( the furthest away the target can get in one scansweep (8 turns) is (ourMaxVelocity + targetMaxVelocity) * number of turns a scansweep takes. ( 8 + 8 ) * 8
		//This may lose target if target moves in a way that makes our scansweep take more than 8 turns, but that won't happen often
		if ( targetDistance < trackingTargetDistance + 160 ) {
			trackingTargetDistance = targetDistance;
			//turn gun to aim at target
			setTurnGunRightRadians( Math.sin( targetBearing - getGunHeadingRadians() ) );
			if ( getGunHeat() < 1 ) {
				setTurnRadarLeftRadians( getRadarTurnRemainingRadians() );
			}
		}
		//turn tank away from the anit gravity force. wall anti-gravity implemented
		setTurnRightRadians( ( Math.atan2( forceX + 1 / getX() - 1 / ( getBattleFieldWidth() - getX() ) , forceY + 1 / getY() - 1 / ( getBattleFieldHeight() - getY() ) ) - ourHeading + ( 7 * Math.PI ) ) % ( 2 * Math.PI ) - Math.PI );
		setAhead( Double.POSITIVE_INFINITY );
		setMaxVelocity( 360 / getTurnRemaining() );
	
		//shoot with lower power when few enemies
		fireBullet( others );
	//	execute();
	}
	
	//free the target we are tracking if a robot dies
	public void onRobotDeath( RobotDeathEvent e ) {
		trackingTargetDistance = Double.POSITIVE_INFINITY;
	}
}
