package bvh.two;

import java.io.IOException;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Point2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.Color;
import java.util.*;


/**
 * <h2>Valkirie</h2> <h3>- a robot by Bart "Loki" van Hest</h3>
 *
 * <p>The valkyries were dsir, minor female deities, who serve Odin. The name 
 * means choosers of the slain."</p>
 * <p>The valkyries' purpose was to choose the most heroic of those who had died 
 * in battle and to carry them off to Valhalla where they became einherjar. This 
 * was necessary because Odin needed warriors to fight at his side at the preordained 
 * battle at the end of the world, Ragnark.</p>
 *
 *
 * <p>Wijzigingshistorie v0.1 (26-11-2005):
 * <ul>
 *  <li>Gebaseerd op bvh.mini.Freya v0.44</li>
 *  <li>Aangepast om als team-robot te werken.</li>
 * </ul>
 * </p>
 *
 * @version 1.0
 * @author Bart van Hest
 */
public class Valkirie extends TeamRobot implements Constanten {
   private static Hashtable        doelen;
   private Doel                    doel;
   private Point2D.Double positie;
   private Point2D.Double bestemming;

   public void run() {
      Color p = Color.pink.darker();
      setColors(p, p, p);

      setAdjustGunForRobotTurn(true);
      setAdjustRadarForGunTurn(true);

      // initialiseer omhullenden die bepalend zijn voor inschatten positie van doel op het slagveld:
// minimimusculum ... verklein de "codesize"
//      bewegingsveld = new RoundRectangle2D.Double(WANDAFSTAND, WANDAFSTAND, getBattleFieldWidth() - 2D * WANDAFSTAND,
//            getBattleFieldHeight() - 2D * WANDAFSTAND, RONDING, RONDING);

      if (doelen == null) {
         doelen = new Hashtable();
      }

      setTurnRadarRightRadians(Double.POSITIVE_INFINITY);

      do {
         positie = new Point2D.Double(getX(), getY());

         if (bestemming == null) {
            bestemming = positie;
         }

         if (doel != null) {
            stuurRadar(doel);
            navigatie();
            stuurKanon();
         }

         execute();
      } while (true);
   }

   public void onScannedRobot(ScannedRobotEvent evt) {
      String naam = evt.getName();
         Doel d = null;
         d = (Doel) doelen.get(naam);

         if (d == null) {
            d = new Doel();
         }

         // bijwerken globale data
         d.actief = true;
         d.naam = naam;
         d.energie = evt.getEnergy();
         Point2D.Double pos = projecteerPositie(positie,
               d.richting = Utils.normalRelativeAngle(getHeadingRadians() + evt.getBearingRadians()), evt.getDistance());
         d.x = pos.x;
         d.y = pos.y;
//         d.lateraleSnelheid = (d.snelheid = evt.getVelocity()) * Math.sin(evt.getHeadingRadians() - d.richting);
//         d.transversaleSnelheid = d.snelheid * Math.cos(evt.getHeadingRadians() - d.richting);
         d.lateraleSnelheid = evt.getVelocity() * Math.sin(evt.getHeadingRadians() - d.richting);
         d.transversaleSnelheid = evt.getVelocity() * Math.cos(evt.getHeadingRadians() - d.richting);

         opslaanDoel(d);

         // vuur test-golf:
         addCustomEvent(new MicroGolf(d, positie, d.richting, (20D-3D*bepaalKanonVuurkracht(d)),
               (d.cirkelRichting = d.lateraleSnelheid < 0 ? -1D / GF_MIDDEN : 1D / GF_MIDDEN), geefGFStats(d)));

         try {
            broadcastMessage(d);
         } catch (IOException e) {
//            System.out.println("IOException= " + e);
         }
   }

   public void onMessageReceived(MessageEvent evt) {
      opslaanDoel((Doel) evt.getMessage());
   }

   private void opslaanDoel(Doel nieuweInfo) {
      // opslaan doel-gegevens:
      Doel d = null;
      d = (Doel) doelen.get(nieuweInfo.naam);

      if (d == null) {
         d = nieuweInfo;
         doelen.put(d.naam, d);
      }
      // selectie doel:
      if (!isTeammate(d.naam)
            && (doel == null || !doel.actief
            || ((getGunHeat() / getGunCoolingRate()) > 5D
            && (d.energie * Math.pow(positie.distance(d.x, d.y), 2D) < doel.energie * Math.pow(positie.distance(doel.x, doel.y), 2D))))) {
         doel = d;
      }
   }

   public void onRobotDeath(RobotDeathEvent evt) {
      ((Doel)doelen.get(evt.getName())).actief = false;
   }

   public void onDeath(DeathEvent evt) {
      for (Enumeration en = doelen.elements(); en.hasMoreElements();) {
         ((Doel) en.nextElement()).actief = false;
      }
   }

   private void navigatie() {
      Point2D.Double testPositie;
      double         afstotingLaatstePositie;
      double         pogingen = 0;

      if (positie.distance(bestemming) < 72D) {
         afstotingLaatstePositie = 1.0D - Math.rint(Math.pow(Math.random(), getOthers()));
// variabelen verwijderen en waarden elke poging opnieuw berekenen: 
// minder codesize, meer rekenkracht: het aantal overgeslagenbeurten is ???
//         double risicoBestemming = weeg(bestemming, afstotingLaatstePositie);
//         double risicoTestPositie;

         do {
            testPositie = projecteerPositie(positie, TWEEPI * Math.random(),
                  Math.min(100 + Math.random() * 200, (getOthers() > 4 ? 0.8 : 0.4) * positie.distance(doel.x, doel.y)));
//            risicoTestPositie = weeg(testPositie, afstotingLaatstePositie);

            if ((new RoundRectangle2D.Double(WANDAFSTAND, WANDAFSTAND, getBattleFieldWidth() - 2D * WANDAFSTAND,
            getBattleFieldHeight() - 2D * WANDAFSTAND, RONDING, RONDING)).contains(testPositie) && weeg(testPositie, afstotingLaatstePositie) < weeg(bestemming, afstotingLaatstePositie)) {
               bestemming = testPositie;
//               risicoBestemming = risicoTestPositie;
            }
         } while (pogingen++ < 200);
      }

      // controleer of draaihoek gelijk is aan minimale draaihoek:
// codesize komt op 1501: bezuinigen op leesbaarheid... 
// variabelen "pogingen" en "afstotingLaatstePositie" hergebruiken...
//      double hoek = Utils.normalRelativeAngle(bepaalRichting(positie, bestemming) - getHeadingRadians());
//      double draaiHoek = Math.atan(Math.tan(hoek));
      afstotingLaatstePositie = Utils.normalRelativeAngle(bepaalRichting(positie, bestemming) - getHeadingRadians());
      pogingen = Math.atan(Math.tan(afstotingLaatstePositie));

      // draai en verplaats robot:
      setAhead(positie.distance(bestemming) * (afstotingLaatstePositie == pogingen ? 1 : -1));
      setTurnRightRadians(pogingen);

      // eventueel snelheid minderen om sneller te kunnen draaien:
      if ((pogingen = Math.abs(getTurnRemainingRadians())) > KWARTPI) {
         setMaxVelocity((HALFPI - pogingen) / 0.1D);
      } else {
         setMaxVelocity(MAXIMUM_SNELHEID);
      }
   }

   public double weeg(Point2D.Double p, double r) {
      double eval = r / (12D*p.distanceSq(positie));

      for (Enumeration en = doelen.elements(); en.hasMoreElements();) {
         Doel d = (Doel) en.nextElement();
         
         if (d.actief) {
            Point2D.Double doelPos = new Point2D.Double(d.x, d.y);
            eval += (Math.min(d.energie / getEnergy(), 2) * (1.0D
            + Math.abs(Math.cos(bepaalRichting(positie, p) - bepaalRichting(doelPos, p))))) / p.distanceSq(doelPos);
         }
      }

      return eval;
   }

   public int[] geefGFStats(Doel d) {
      return (d.guessFactors[getOthers() == 1 ? 0 : 1][(new Ellipse2D.Double(0, 0, getBattleFieldWidth(),
         getBattleFieldHeight())).contains(d.x, d.y)
      ? ((new Ellipse2D.Double((getBattleFieldWidth() - DIAMETERBINNENCIRKEL) / 2D,
         (getBattleFieldHeight() + DIAMETERBINNENCIRKEL) / 2D, DIAMETERBINNENCIRKEL, DIAMETERBINNENCIRKEL)).contains(d.x, d.y)
      ? 1 : 2) : 0][Math.min((int) (positie.distance(d.x, d.y) / 150D), AFSTANDSEGMENTEN)][(int) Math.abs(d.lateraleSnelheid)][(int) Math
      .abs(d.transversaleSnelheid)]);
   }

   private void stuurKanon() {
      int schattingGF = GF_MIDDEN;

      // schiet direct op doel indien dit stationair is doordat het bijna is uitgeschakeld
      if (!(doel.energie == 0)) {
         // anders bepaal meest waarschijnlijke schietrichting
         int[] stats = geefGFStats(doel);

         for (int gf = (2 * GF_MIDDEN); gf >= 0; gf--)
            if (stats[gf] > stats[schattingGF]) {
               schattingGF = gf;
            }
      }

      setTurnGunRightRadians(Utils.normalRelativeAngle(doel.richting - getGunHeadingRadians()
            + doel.cirkelRichting * (schattingGF - GF_MIDDEN)));

      if (Math.abs(getGunTurnRemainingRadians()) < Math.atan2(9D, positie.distance(doel.x, doel.y)) && getEnergy() > STANDAARDVUURKRACHT) {
         setFire(bepaalKanonVuurkracht(doel));
      }
   }

   private double bepaalKanonVuurkracht(Doel d) {
      return (d.energie == 0 ? MINIMUMVUURKRACHT : STANDAARDVUURKRACHT);
   }

   private void stuurRadar(Doel d) {
      if (d.actief && (getOthers() == 1 || (getGunHeat() / getGunCoolingRate()) < 5D)) {
         setTurnRadarRightRadians(2.0D * Utils.normalRelativeAngle(bepaalRichting(positie, d.x, d.y)
               - getRadarHeadingRadians()));
      } else {
         setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
      }
   }

   private static Point2D.Double projecteerPositie(Point2D.Double pos, double richting, double afstand) {
      return new Point2D.Double(pos.x + afstand * Math.sin(richting), pos.y + afstand * Math.cos(richting));
   }

   private static double bepaalRichting(Point2D.Double oorsprong, double x, double y) {
      return bepaalRichting(oorsprong, new Point2D.Double(x, y));
   }

   private static double bepaalRichting(Point2D.Double oorsprong, Point2D.Double doel) {
      return Math.atan2((doel.x - oorsprong.x), (doel.y - oorsprong.y));
   }

   private class MicroGolf extends Condition {
      Point2D.Double startPositie;
      double         afstand;
      double         richting;
      double         cirkelRichting;
      double         kogelSnelheid;
      int[]          stats;
      Doel           doel;

      public MicroGolf(Doel doel, Point2D.Double positie, double doelRichting, double kogelSnelheid,
         double cirkelRichting, int[] stats) {
         this.doel = doel;
         this.startPositie = positie;
         this.richting = doelRichting;
         this.kogelSnelheid = this.afstand = kogelSnelheid;
         this.cirkelRichting = cirkelRichting;
         this.stats = stats;
      }

      /**
       * Method bepaalt of de wave de tegenstander heeft bereikt. Indien dit het geval is
       * wordt de hoek berekend waaronder een kogel afgevuurd had moeten worden om de tegenstander
       * te raken en wordt de corresponderende bin in de GF-statistiek opgehoogd.
       *
       * @return boolean waarde die aangeeft of de wave kan worden verwijdert of niet.
       */
      public boolean test() {
         double nabijheid = (afstand += kogelSnelheid) - startPositie.distance(doel.x, doel.y);

         if (!doel.actief || nabijheid >= 20) {
            removeCustomEvent(this);
         }

         if (Math.abs(nabijheid) <= 20) {
            try {
               stats[(int) Math.round(Utils.normalRelativeAngle(bepaalRichting(startPositie, doel.x, doel.y) - richting) / cirkelRichting) + GF_MIDDEN]++;
            } catch (ArrayIndexOutOfBoundsException e) {
            }
         }

         return false;
      }
   } // einde innerclass met de golf.
} // EINDE CLASS miniWodan
