package wit;
import robocode.*;
import java.util.Random;
import java.awt.Color;
import java.util.*;
import java.util.Random;
/**
 * Deep7 a robot by Waterford Institute of Technology
 * Bill Malone
 * Acknowledgements :-	
 * sample.TrackFire for DirectGun method and SnippetBot@Robowiki for basis of helper methods and Enemy Class
 */
public class Deep7 extends Robot
{
	
	Enemy target;
	private boolean lock = false;
	private double shotWieght = 1;
	private int wallZones = 75;
	private boolean nearwall = false;
	private double centreBearing = 0;
	private double move = 60;
	private double fieldWidth;
	private double fieldHeight;
	private int badShot = 0;
		
	
	/**
	 * Deep7's run method
	 */
	public void run() {
		setColors(Color.black,Color.black,Color.black);
		fieldWidth = getBattleFieldWidth();
		fieldHeight = getBattleFieldHeight();
		target = new Enemy();
		target.distance = 10000;
		centreBearing = absbearing(getX(),getY(), fieldWidth/2, fieldHeight/2);// based on centre of the field
		double turn = normalRelativeAngle(centreBearing - getHeading());		//Get to
		turnRight(turn);														//the
		ahead(getrange(getX(), getY(), fieldWidth/2, fieldHeight/2));			//middle first
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		turnRadarRight(360); // scan the field once
		
		while (true)
		
		{	
			
			turnRadarRight(45);
			 
			//info();
		}
	}
	
	public void Move()
	{
		if (getX()<wallZones || getY()<wallZones || getX()>getBattleFieldWidth()-wallZones || getY()>getBattleFieldHeight()-wallZones)
		{
			nearwall = true;
			wallAvoid();	//goto wall avoid method if outside of boundaries defined by wallZones
		}
		else
		{	
			nearwall = false;
			/**
			if (Math.abs(target.bearing) > 45 && Math.abs(target.bearing) < 135)
			{
				System.out.println("No turn");
				return;
			}
			*/
			if (!nearwall)
			{
			if (target.bearing > -90 && target.bearing < 0 || target.bearing > 90 && target.bearing < 180)
			{
				
				turnRight(Math.abs(Math.abs(target.bearing) - 90));
			}
				else
				{
					
					turnLeft(Math.abs(Math.abs(target.bearing) - 90));
				}
			}
		double moveAmt = 0;
			moveAmt = move * Math.sin(getTime()/3);
			if ( moveAmt < 0 )		//Minimum move adjust
			{
				moveAmt -= 30;
			}
			else 
			{
				moveAmt += 30;
			}
			ahead(Math.abs(moveAmt)); 	//Unidirectional
			//ahead(moveAmt);				//bi directional defined by sin of time
			}
		}
		public void onHitWall(robocode.HitWallEvent e)
	{
		System.out.println("KERRRRAAAAAASSSSSHHH!!!!!!  I hit the wall, who is driving this thing???");
	}
		
		public void wallAvoid()
	{
		System.out.println("WARNING*********WARNING*********WARNING*********");
		   	   	
		centreBearing = absbearing(getX(),getY(), fieldWidth/2, fieldHeight/2);// based on centre of the field
		double turn = normalRelativeAngle(centreBearing - getHeading());
		if ( turn > 0 )
		{
			turn += 67.5;
		}
		else
		{
			turn -= 67.5;
		}
		turnRight(turn);
		ahead(wallZones);
		}	
		
	
	
	/**
	 * onScannedRobot:  
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		        if ((e.getDistance() < target.distance)||(target.name.equals(e.getName())))
		{						       
		//the next line gets the absolute bearing to the point where the bot is
                double absbearing_rad = (getHeading() + e.getBearing());
				
                    
		//this section sets all the information about our target
                target.name = e.getName();
                target.x = getX() + (Math.sin(Math.toRadians(absbearing_rad))*e.getDistance()); //works out the x coordinate of where the target is
                target.y = getY() + (Math.cos(Math.toRadians(absbearing_rad))*e.getDistance()); //works out the y coordinate of where the target is
				target.bearing = e.getBearing();
                target.head = e.getHeading();
                target.ctime = getTime();				//game time at which this scan was produced
                target.speed = e.getVelocity();
                target.distance = e.getDistance();
				target.energy = e.getEnergy();
				if (badShot%12 == 0){ badShot = 0;}
				if ( badShot < 9 )
				{
					AimGun();
				}
				else
				{
					DirectGun();
				}
				Move();
		
				lock = true;
		}
		
		}
		
		public void onHitRobot(HitRobotEvent e) {
		
		double turnGunAmt = normalRelativeAngle(e.getBearing() + getHeading() - getGunHeading());
		turnGunRight(turnGunAmt);
		fire(3);
		}
	
	public void info()
	{
		
		//System.out.println("************************************");
		//System.out.println("getX() " + getX() + " getY() " + getY());
		//System.out.println("Target Distance " + target.distance);
		//System.out.println("Target coords " + target.x + " X  and " + target.y + " Y");
		//System.out.println("getTime() " + getTime());
		//System.out.println("getX() " + getX() + " getY() " + getY());
		//System.out.println("Target coords " + target.x + " X  and " + target.y + " Y");
		//System.out.println("long time = " + time);
		//System.out.println("target.guessX " + target.guessX(time));
		//System.out.println("target.guessY " + target.guessY(time));
		//System.out.println("getHeading() " + getHeading());
		//System.out.println("E.getBearing() " + e.getBearing());
		//System.out.println("Math.abs target.bearing " + (Math.abs(target.bearing)));
		//System.out.println("Target.bearing() " + target.bearing);
		//System.out.println("Target Distance " + e.getDistance());
		//System.out.println("Target coords " + target.x + " X  and " + target.y + " Y");
		//System.out.println("All set up for enemy info");
		//System.out.println("target.name = " + e.getName());
		//System.out.println("Math.sin " + Math.sin(Math.toRadians(absbearing_rad))*e.getDistance());
		//System.out.println("Math.cos " + Math.cos(Math.toRadians(absbearing_rad))*e.getDistance());
		//System.out.println("absBearing_rad " + absbearing_rad);
		//System.out.println("turn " + turn + " = centreBearing " + centreBearing + " - getHeading() " + getHeading());
		//System.out.println("Target is now " + target.name);
		//System.out.println("getGunHeading() = " + getGunHeading());
		//System.out.println("absbearing in gun routine =" + absbearing(getX(),getY(),target.guessX(time),target.guessY(time)));
		//System.out.println("gunOffset = " + gunOffset);
		//System.out.println("normalRelAng of gunOffset = " + normalRelativeAngle(gunOffset));
		//System.out.println("Bearing from gun " + bearingFromGun);
		//System.out.println("TurnRight");
		//System.out.println("TurnLeft");		
		
		
	}
	
	public double shotWieght()
	{
		if (getEnergy() >  5)
		{
		shotWieght = 400/target.distance;
		}
				else 
				{			
				shotWieght = 0.1;
				}
		return shotWieght;
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
                if (e.getName().equals(target.name))
                target.distance = 10000; 	//this will effectively make it search for a new target
		        }
		
	public void onBulletMissed( BulletMissedEvent e)
	{
		badShot ++;
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		badShot --;
		return;
		
	}
	
	public void AimGun()
	{
	//works out how long it would take a bullet to travel to where the enemy is *now*
        //this is the best estimation we have
	
        long time = getTime() + (int)(target.distance/(20-(3*shotWieght)));
		
		
        //offsets the gun by the angle to the next shot based on linear targeting provided by the enemy class
        double gunOffset = getGunHeading() - absbearing(getX(),getY(),target.guessX(time),target.guessY(time));
		turnGunLeft(normalRelativeAngle(gunOffset));
		if (getGunHeat() == 0)
		{
		fire(shotWieght());
		}
	}
	
	public void DirectGun()  //**********from sample TrackFire
	{
		// Calculate exact location of the robot
		double absoluteBearing = getHeading() + target.bearing;
		double bearingFromGun = normalRelativeAngle(absoluteBearing - getGunHeading());
		
		// If it's close enough, fire!
		if (Math.abs(bearingFromGun) <= 3) {
			turnGunRight(bearingFromGun);
			// We check gun heat here, because calling fire() 
			// uses a turn, which could cause us to lose track
			// of the other robot.
			if (getGunHeat() == 0)
				fire (Math.min(3 - Math.abs(bearingFromGun),getEnergy() - .1));
		}
		// otherwise just set the gun to turn.
		// Note:  This will have no effect until we call scan()
		else {
			turnGunRight(bearingFromGun);
		}
		// Generates another scan event if we see a robot.
		// We only need to call this if the gun (and therefore radar)
		// are not turning.  Otherwise, scan is called automatically.
		if (bearingFromGun == 0)
			scan();
		//turnRight(target.bearing - 90);
	}
	
	public void onWin(WinEvent e)
	{
		centreBearing = absbearing(getX(),getY(), fieldWidth/2, fieldHeight/2);// based on centre of the field
		double turn = normalRelativeAngle(centreBearing - getHeading());
		turnRight(turn);
		ahead(getrange(getX(), getY(), fieldWidth/2, fieldHeight/2));
		while (true){
		turnGunLeft(45);
		fire(0.1);}
	}
	
	// Helper functions
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180)
			return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -180)
			fixedAngle += 360;
		while (fixedAngle > 180)
			fixedAngle -= 360;
		return fixedAngle;
	}
	
	//returns the distance between two x,y coordinates
        public double getrange( double x1,double y1, double x2,double y2 )
        {
                double xo = x2-x1;
                double yo = y2-y1;
                double h = Math.sqrt( xo*xo + yo*yo );
                return h;
        }
	
	//gets the absolute bearing between two x,y coordinates
        public double absbearing( double x1,double y1, double x2,double y2 )
        {
                double xo = x2-x1;
                double yo = y2-y1;
                double h = getrange( x1,y1, x2,y2 );
                if( xo > 0 && yo > 0 )
                {
                        return Math.toDegrees(Math.asin( xo / h ));
                }
                if( xo > 0 && yo < 0 )
                {
                        return 180 - Math.toDegrees(Math.asin( xo / h ));
                }
                if( xo < 0 && yo < 0 )
                {
                        return 180 + Math.toDegrees(Math.asin( -xo / h ));
                }
                if( xo < 0 && yo > 0 )
                {
                        return 360 - Math.toDegrees(Math.asin( -xo / h ));
                }
                return 0;
        }

}

				class Enemy {
        /*
        * Class to hold all current
        * target information
        */
        String name;
        public double bearing;
        public double head;
        public long ctime; //game time that the scan was produced
        public double speed;
        public double x,y;
        public double distance;
        public double energy;
		
		
		
		
		public double guessX(long when)
		
        	{
                long diff = when - ctime;
		if (x+Math.sin(Math.toRadians(head))*speed*diff >= 0)
		{
				/**
				System.out.println("target.heading " + head);
				System.out.println("speed = " + speed);
				System.out.println("diff + " + diff);
				System.out.println("Enemy Class calc Math.sin(Math.toRadians(head))*speed*diff " + (x+Math.sin(Math.toRadians(head))*speed*diff));
				*/
				return x+Math.sin(Math.toRadians(head))*speed*diff;
												
		}
		else
		{
		return -1;
		}
        }
        public double guessY(long when)
        {
                long diff = when - ctime;
				return y+Math.cos(Math.toRadians(head))*speed*diff;
								
        }

}//End of target class				