package DTF.modules;

import DTF.Util;

public class Genotype implements Comparable<Genotype> {
	private double lastScore;
	private double score;
	private double rounds;
	private int actualRounds;
	
	public double[] values;
	
	public Genotype(double[] values) {
		this.values=values.clone();
		lastScore=score=0.0;
		rounds=0;
		actualRounds=0;
	}
	
	public void addScore(double score) {
		this.score+=score;
		lastScore=score;
		rounds+=1.0;
		actualRounds++;
		
		//decay to favor recent scores
		score*=0.75;
		rounds*=0.75;
	}
	
	public double getScore() {
		if(rounds==0) return 0.0;
		//A bit of a second chance for often high scoring elders who have a bad day
		double altScore=(lastScore + score/(rounds+1.0))*0.5;
		
		return Math.max(lastScore,altScore);
	}
	
	
	public String toString() {
		return Util.formatDouble(getScore())+","+actualRounds+","+Util.join(values,",");
	}
	
	public void crossOver(Genotype other) {
		//mix gene with other without losing values
		for(int i=0;i<values.length;i++) {
			if(Math.random()<0.5) {
				double t=other.values[i];
				other.values[i]=values[i];
				values[i]=t;
			}
		}
	}

	/*@Override not supported in 1.5 */
	public int compareTo(Genotype other) {
		double diff=getScore()-other.getScore();
		if(diff>0) return 1;
		if(diff<0) return -1;
		return 0;
	}

	
	/*public Gene(Gene p1, Gene p2, boolean blend) {
		values=new double[p1.values.length];
		for(int i=0;i<values.length;i++) {
			double a=
		}
		
	}*/
}
