package suh.nano;

import java.awt.geom.Point2D;
import robocode.*;
import robocode.util.Utils;

public class TargetC extends AdvancedRobot {
    private double lastEnemyHeading;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    execute();
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	double ex = e.getDistance() * Math.sin(bearing);
	double ey = e.getDistance() * Math.cos(bearing);
				
	double dis = 0;
	double heading = lastEnemyHeading;
	do {
	    dis += Rules.getBulletSpeed(3);
	    heading += e.getHeadingRadians() - lastEnemyHeading;
	    ex += e.getVelocity() * Math.sin(heading);
	    ey += e.getVelocity() * Math.cos(heading);
	} while (dis < Point2D.distance(0, 0, ex, ey));

	setTurnGunRightRadians(Utils.normalRelativeAngle(Math.atan2(ex, ey) - getGunHeadingRadians()));
	setFire(3);
	
	lastEnemyHeading = e.getHeadingRadians();
    }
}
