package kawigi.spare.parts;
import kawigi.spare.util.*;
import robocode.*;
/**
 * MovementStrategy - an abstract class for robot movement control
 */
public abstract class MovementStrategy extends Part implements java.io.Serializable
{
	private TargetSelector targetter;
	
	public MovementStrategy(AdvancedRobot robot, TargetSelector targetter)
	{
		super(robot);
		this.targetter = targetter;
	}
	
	public EnemyState getClosestEnemy()
	{
		return targetter.getClosestEnemy();
	}
	
	public EnemyState getTarget()
	{
		return ((TargetChooser)targetter.getSelectedPart()).chooseTarget();
	}
}
