package kawigi.spare.util;

/**
 * Averager - keeps track of the average of recent data.
 */
public class Averager
{
	private int totalentries;
	private double[] recent;
	
	public Averager(int size)
	{
		recent = new double[size];
		totalentries = 0;
	}
	
	public void addEntry(double entry)
	{
		recent[totalentries%recent.length] = entry;
		totalentries++;
	}
	
	public double recentAverage()
	{
		if (totalentries == 0)
			return 0;
		double total = 0;
		for (int i=0; i<Math.min(totalentries, recent.length); i++)
			total += recent[i];
		return total/Math.min(totalentries, recent.length);
	}
	
	public int totalEntries()
	{
		return totalentries;
	}
	
	public int recordedEntries()
	{
		return Math.min(totalentries, recent.length);
	}
}