/*
 * Created on 27/10/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.gunner;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;

import axeBots.musashi.*;
import axeBots.util.*;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AimStatHolder {
    public static final int DISTANCE_SLICES= 6;
    public static final int ANGLE_SLICES= 4;
    public static final int OPPS_SLICES= 2;
    private long stats[][][]=
        new long[OPPS_SLICES][ANGLE_SLICES][DISTANCE_SLICES];

    public static final int DISTANCE_SLICE_EDGE[]= {0,100,200,300,500,800,5000};
    public static final int ANGLE_SLICE_SIZE= 90;
    public static final int MELEE= 0;
    public static final int DUEL= 1;
    private int id;
    /**
     * 
     */
    public AimStatHolder(int id) {
        super();
        this.id= id;
        // TODO Auto-generated constructor stub
    }

    public void hit(double opps, double angle, double dist) {
        int o= this.getOppsInd(opps);
        int a= this.getAngleInd(angle);
        int d= this.getDistInd(dist);
        stats[o][a][d] <<= 1;
        stats[o][a][d]= stats[o][a][d] | 1L;
    }

    public void miss(double opps, double angle, double dist) {
        int o= this.getOppsInd(opps);
        int a= this.getAngleInd(angle);
        int d= this.getDistInd(dist);
        stats[o][a][d] <<= 1;
    }

    public long get(double opps, double angle, double dist) {
        int o= this.getOppsInd(opps);
        int a= this.getAngleInd(angle);
        int d= this.getDistInd(dist);
        return stats[o][a][d];
    }

    private int getDistInd(double dist) {
		int i;
		for( i=0;i<DISTANCE_SLICES;i++){
			if(dist<DISTANCE_SLICE_EDGE [i+1]){
				break;
			}
		}
		
        return i;
    }

    private int getOppsInd(double opps) {
        return (opps > 1) ? MELEE : DUEL;
    }

    private int getAngleInd(double ang) {
        ang= RoboMath.normalRelativeAngle(ang);
        if ((ang > (-45)) && (ang < (45))) {
            return 0;
        } else if ((ang > (45)) && (ang < (135))) {
            return 1;
        } else if ((ang > (135)) || (ang < (-135))) {
            return 2;
        } else if ((ang > (-135)) && (ang < (-45))) {
            return 3;
        } else
            return 4;
    }

    public static String getAngleLabel(int strat) {
        switch (strat) {
            case 0 :
                return "FRONTAL";
            case 1 :
                return "ESQUERDA";
            case 2 :
                return "AFASTANDO";
            case 3 :
                return "DIREITA";
        }
        return "NOTFOUND";
    }

    public static void saveHeader(DataOutputStream w) throws IOException {
        w.writeByte((byte)OPPS_SLICES);
        w.writeByte((byte)ANGLE_SLICES);
        w.writeByte((byte)DISTANCE_SLICES);
    }

    public static void loadHeader(DataInputStream r) throws IOException {
        if ((OPPS_SLICES != r.readByte())
            || (ANGLE_SLICES != r.readByte())
            || (DISTANCE_SLICES != r.readByte())) {
            throw new IOException("AimStatsHolder wrong expected data.");
        }
    }

    public void save(DataOutputStream w) throws IOException {
        for (int i= 0; i < OPPS_SLICES; i++) {
            for (int j= 0; j < ANGLE_SLICES; j++) {
                for (int k= 0; k < DISTANCE_SLICES; k++) {
                    w.writeLong(stats[i][j][k]);
                }
            }
        }
    }

    public void load(DataInputStream r) throws IOException {
        for (int i= 0; i < OPPS_SLICES; i++) {
            for (int j= 0; j < ANGLE_SLICES; j++) {
                for (int k= 0; k < DISTANCE_SLICES; k++) {
                    stats[i][j][k]= r.readLong();
                }
            }
        }
    }

    public int getHits(long rate,int start, int end) {
        int wideness= end - start;
        
        int hits= 0;
        if (wideness <= 0) {
            return 0;
        }
        rate >>= start;
        for (int i= 0; i <= wideness; i++) {

            hits += rate & 1L;
            rate >>= 1;
        }
        return hits;
    }
    
	public String getString(double opps, double angle, double dist) {
		int o= this.getOppsInd(opps);
		int a= this.getAngleInd(angle);
		int d= this.getDistInd(dist);
		
		DecimalFormat forma=
							new DecimalFormat("00000000,00000000,00000000,00000000,00000000,00000000,00000000,00000000");
		
		return 
//		forma.format(
//		Double
//			.valueOf(
			Long.toBinaryString(stats[o][a][d])//)
//			.doubleValue())
		+ " "
		+ Stratego.getStratName(id)
		+ " "
		+ this.getOppsLabel(o)
		+ " "
		+ this.getAngleLabel(a)
		+ " "
		+ this.getDistanceLabel(d);
	}
    
    public static String getDistanceLabel(int dist) {
    	
        switch (dist) {
            case 0 :
                return DISTANCE_SLICE_EDGE[0]+ "-"+DISTANCE_SLICE_EDGE[1] ;
            case 1 :
			return DISTANCE_SLICE_EDGE[1]+ "-"+DISTANCE_SLICE_EDGE[2] ;
            case 2 :
			return DISTANCE_SLICE_EDGE[2]+ "-"+DISTANCE_SLICE_EDGE[3] ;
            case 3 :
			return DISTANCE_SLICE_EDGE[3]+ "-"+DISTANCE_SLICE_EDGE[4] ;
            case 4 :
			return DISTANCE_SLICE_EDGE[4]+ "-"+DISTANCE_SLICE_EDGE[5] ;
            case 5 :
			return DISTANCE_SLICE_EDGE[5]+ "-..." ;
        }
        return "NOTFOUND";
    }
    public static String getOppsLabel(int opps) {
        switch (opps) {
            case MELEE :
                return "MELEE";
            case DUEL :
                return "DUEL";
        }
        return "NOTFOUND";
    }
    public String toString() {

        StringBuffer str= new StringBuffer();

        DecimalFormat forma=
            new DecimalFormat("00000000,00000000,00000000,00000000,00000000,00000000,00000000,00000000");

        for (int i= 0; i < OPPS_SLICES; i++) {
            for (int j= 0; j < ANGLE_SLICES; j++) {
                for (int k= 0; k < DISTANCE_SLICES; k++) {

                    str.append(
//                        forma.format(
//                            Double
//                                .valueOf(
                                Long.toBinaryString(stats[i][j][k])//)
//                                .doubleValue())
                            + " "
                            + Stratego.getStratName(id)
                            + " "
                            + this.getOppsLabel(i)
                            + " "
                            + this.getAngleLabel(j)
                            + " "
                            + this.getDistanceLabel(k)+"\r\n");
                }
            }
        }

        return str.toString();
    }

}
