package step;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class NanoBidu extends AdvancedRobot {
	
	static double lastHeadling=0;
	public void run() {
		setAdjustGunForRobotTurn(true);
		setTurnRadarLeftRadians(Double.POSITIVE_INFINITY);
	}

	
	public void onScannedRobot(ScannedRobotEvent e) {
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
		double w=e.getHeadingRadians()-lastHeadling;
		lastHeadling=e.getHeadingRadians();
		double absBearing=getHeadingRadians()+e.getBearingRadians();
		double ex=e.getDistance()*Math.sin(absBearing);
		double ey=e.getDistance()*Math.cos(absBearing);
		double db=0,ww=lastHeadling;
		double bulletEnergy=Math.min( (40*getEnergy()/e.getDistance()), 3);
		do{
			db+=20-(3*bulletEnergy);
			ex+=e.getVelocity()*Math.sin(ww);
			ey+=e.getVelocity()*Math.cos(ww);
			ww+=w;
		}while(db<Point2D.distance(0,0,ex,ey));
		setTurnGunRightRadians( Utils.normalRelativeAngle(Math.atan2(ex,ey)-getGunHeadingRadians()) );
		setFire(bulletEnergy);
		setTurnRightRadians(Math.cos(e.getBearingRadians()));
		if (getDistanceRemaining() == 0)
		setAhead(400 * Math.random() - 200);
	}
}
