package franzor;

import franzor.guns.*;
import robocode.*;
import robocode.util.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
/**
 * Lizt - a robot by Franzor
 */
public class Lizt extends AdvancedRobot {
	private Map enemyLocations;
	private static Map enemyStatistics = new HashMap();
	
	private Point2D myLoc;
	private double wGravity, eGravity;
	private String attack;
	private static final double vbullet = 14; //speed of a 2 powered bullet
	
	private Gun dgun, lgun;
	
	private boolean forward;
	
	/**
	 * run: Lizt's default behavior
	 */
	public void run() {
		enemyLocations = new HashMap();
		myLoc = new Point2D.Double(getX(), getY());
		
		dgun = new DisplacementGun();
		lgun = new LinearGun();
		
		attack = null;
		wGravity = 800;
		eGravity = 1000;
		
		setColors(Color.orange, Color.white, Color.orange.darker());
		
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		int count = 0;
		Random rand = new Random();
		while(true) {
			myLoc.setLocation(getX(), getY());
							
			if(count == 0) {
				forward = (rand.nextInt()%2 == 0);
								
				if(getBattleFieldWidth() <= 600)
					count += 5;
				count += (int)(getGunCoolingRate() * 10);
				count += 10;
			}
			
			moveAGDirection();
			
			if(forward) {
				setAhead(5000);
			} else {
				setBack(5000);
			}
			
			if(attack != null && getGunHeat() == 0) {
				Info info = (Info)enemyLocations.get(attack);
				StatPack stats = (StatPack)enemyStatistics.get(attack);
				
				Point2D dtarget = dgun.getGunTarget(info, stats, this, vbullet);
				Point2D ltarget = lgun.getGunTarget(info, stats, this, vbullet);
				
				double velocity = info.velocity().getMagnitude();
				double dist = myLoc.distance(info.location());
				//consider adding waves for all guns	
				
				if(stats != null && info != null) {
					double linProb, statProb;
					
					linProb = stats.getLinearHitRate(dist, velocity);
					statProb = stats.getStatHitRate(dist, velocity);
					
					if(dtarget != null && isInBounds(dtarget) 
						&& statProb > linProb && statProb > .25) {
						turnGunToPoint(dtarget);
							
						if(Math.abs(getGunTurnRemainingRadians()) <= Math.PI/16) {
							fire((dist > 50)?2:3);
							out.println("Displacement Gun--" + statProb);
						}
					} else if(ltarget != null && isInBounds(ltarget) && statProb > .25) {
						turnGunToPoint(ltarget);
						
						if(Math.abs(getGunTurnRemainingRadians()) <= Math.PI/16) {
							fire((dist > 50)?2:3);
							out.println("Linear Gun--" + linProb);
						}
					} else if(dist < 50) {
						turnGunToPoint(info.location());
						if(Math.abs(getGunTurnRemainingRadians()) <= Math.PI/16)
							fire(3);
						out.println("Dead On");
					}
				}
			}
					
			
			execute();
			count--;
		}
	}	
	
	private void moveAGDirection() {
		MathVector mv = new MathVector(0, 0);
		Iterator iter = enemyLocations.keySet().iterator();

		while(iter.hasNext()) {
			String name = (String)iter.next();
			Point2D enemy = ((Info)enemyLocations.get(name)).location();
			double dir = robocode.util.Utils.normalRelativeAngle(toDirection(enemy, myLoc));
			double dist = enemy.distance(myLoc);
			mv.add(eGravity/(dist*dist), dir);
		}
		
		if(getOthers() == 1 && attack != null) { //RETREAT!
			String name = attack;
			Point2D enemy = ((Info)enemyLocations.get(name)).location();
			double dir = robocode.util.Utils.normalRelativeAngle(toDirection(enemy, myLoc));
			double dist = enemy.distance(myLoc);
			mv.add(5*eGravity/(dist*dist), dir);
		}
		
		//Wall forces
		mv.add(wGravity/(getX()*getX()), Math.PI/2);
		mv.add(wGravity/(getY()*getY()), 0);
		double tmp = getBattleFieldWidth() - getX();
		mv.add(wGravity/((tmp*tmp)), 3*Math.PI/2);
		tmp = getBattleFieldHeight() - getY();
		mv.add(wGravity/((tmp*tmp)), Math.PI);
		
		//Center to avoid crossfire when numBots >= 8
		if(getOthers() >= 8) {
			Point2D ctr = new Point2D.Double(getBattleFieldWidth()/2, getBattleFieldHeight()/2);
			double dir = robocode.util.Utils.normalRelativeAngle(toDirection(ctr, myLoc));
			double dist = ctr.distance(myLoc);
			mv.add(wGravity/(dist*dist), dir);
		}
		
		double dirAngle = mv.getDirection();
		double headAngle = getHeadingRadians();
		double diff = robocode.util.Utils.normalRelativeAngle(dirAngle - headAngle);
		diff *= (forward)?1:-1;
		setTurnRightRadians(diff);
	}
	
	private void turnGunToPoint(Point2D loc) {
		if(loc == null) return;
		
		double bearing = toDirection(new Point2D.Double(getX(), getY()), loc);
		double realBearing = robocode.util.Utils.normalRelativeAngle(bearing - getGunHeadingRadians());
		
		if(realBearing > 0) {
			setTurnGunRightRadians(realBearing + Math.PI/32);
		} if(realBearing < 0) {
			setTurnGunLeftRadians((-1)*realBearing + Math.PI/32);
		}	
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		double absBear = getHeadingRadians() + e.getBearingRadians();
		Point2D loc = toLocation(absBear, e.getDistance(), myLoc);
		
		enemyLocations.put(e.getName(), new Info(loc, new MathVector(e.getVelocity(), e.getHeadingRadians())));
		
		if(!enemyStatistics.containsKey(e.getName())) {
			enemyStatistics.put(e.getName(), new StatPack());
			out.println("creating StatPack for: " + e.getName());
		}
		((StatPack)enemyStatistics.get(e.getName())).addData(getTime(), loc, new MathVector(e.getVelocity(), e.getHeadingRadians()));
		
		
		StatPack stats = (StatPack)enemyStatistics.get(e.getName());
		Info info = (Info)enemyLocations.get(e.getName());
		
		addCustomEvent(new WaveCondition(myLoc, loc, 
										 lgun.getGunTarget(info, stats, this, vbullet),
										 dgun.getGunTarget(info, stats, this, vbullet),
										 e.getVelocity(), e.getName()));
		
		if(enemyLocations.get(attack) != null) {
			Point2D cur = ((Info)enemyLocations.get(attack)).location();
			if(cur != null) {
				if(myLoc.distance(cur) > myLoc.distance(loc))
					attack = e.getName();
			} else {
				attack = e.getName();
			}
		} else {
			attack = e.getName();
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		enemyLocations.remove(e.getName());
		if(e.getName().equals(attack))
			attack = null;
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//turnLeft(90 - e.getBearing());
	}
	
	public void onHitWall(HitWallEvent e) {
		wGravity += 100;
	}
	
	public void onHitRobot(HitRobotEvent e) {
		eGravity += 100;
	}
	
	private Point2D toLocation(double angle, double length, Point2D src) {
		return new Point2D.Double(src.getX() + length*Math.sin(angle), src.getY() + length*Math.cos(angle));
	}
	
	private double toDirection(Point2D from, Point2D to) {
		return Math.atan2((to.getX()-from.getX()), (to.getY()-from.getY()));
	}
	
	private boolean isInBounds(Point2D pt) {
		return (pt.getX() >= 0 && pt.getY() >= 0 && pt.getX() < getBattleFieldWidth() && pt.getY() < getBattleFieldHeight());
	}
	
	private class WaveCondition extends Condition {
		private String name;
		private double distance, velocity;
		private Point2D origin, linear, stat;
		private long time;
		
		public WaveCondition(Point2D o, Point2D e, Point2D l, Point2D s, double velo, String n) {
			name = n;
			distance = o.distance(e);
			velocity = velo;
			origin = o;
			linear = l;
			stat = s;
			time = getTime();
		}
		
		public boolean test() {
			Info info = (Info)enemyLocations.get(name);
			StatPack stats = (StatPack)enemyStatistics.get(name);
			if(info == null || stats == null) {
				removeCustomEvent(this);
				return false;
			}
			
			Point2D enemyLoc = info.location();
			if(enemyLoc == null) {
				removeCustomEvent(this);
				return false;
			}
			if(origin.distance(enemyLoc) > (vbullet*(getTime() - time))) return false;
			if(linear != null) {
				boolean hit = isHit(linear, enemyLoc);
				if(hit) {
					stats.addLinearHitData(distance, hit, velocity);
					linear = null;
				}
			}
			if(stat != null) {
				boolean hit = isHit(stat, enemyLoc);
				if(hit) {
					stats.addStatHitData(distance, hit, velocity);
					stat = null;
				}
			}
			if(origin.distance(enemyLoc) < 1.25*(vbullet*(getTime() - time))) {
				if(linear != null) {
					stats.addLinearHitData(distance, false, velocity);
					linear = null;
				}
				if(stat != null) {
					stats.addStatHitData(distance, false, velocity);
					stat = null;
				}
			}
			if(linear == null && stat == null) {
				removeCustomEvent(this);
			}
			
			return false;
		}
		
		private boolean isHit(Point2D a, Point2D b) {
			return ((a.getX() <= (b.getX() + getWidth())) &&
					(a.getX() >= (b.getX() - getWidth())) &&		
					(a.getY() <= (b.getY() + getHeight())) &&
					(a.getY() >= (b.getY() - getHeight())));
		}
	}
}
