package jaemcrb.nano;
import robocode.*;
//import java.awt.Color;

/**
 * M1Abrams - a robot by Jose Angel Estrada & Cristobal Romero
 * 
 * M1Abrams esta equipado con un sistema que detecta cuando el enemigo ha disparado e intenta esquivar la bala cambiando la direccion de su movimiento, ademas de contar el
 * 			sistema de apuntamiento "Linear Targeting"
 */
public class M1Abrams extends AdvancedRobot
{
	double energiaAnterior = 100;
	int direccion = 1;
	static final int AIM_START = 10;
	static final double AIM_FACTOR = 1.008;
	static final int FIRE_FACTOR = 7;
	static double lastDistance;

	public void run() {
		//setColors(Color.green,Color.black,Color.black); // body,gun,radar
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);		
	}

	public void onScannedRobot(ScannedRobotEvent e) {		
		//bloque Linear Targeting (robowiki)
		double	absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		double  distance = e.getDistance();
		//bloque Esquivar balas.
		setTurnRight(e.getBearing()+90-30*direccion);
		double cambioEnergia = energiaAnterior-e.getEnergy();
		if (cambioEnergia>0 && cambioEnergia<=3) {
			direccion = -direccion;
			setAhead((e.getDistance()/4+25)*direccion);
		}
		//fin bloque Esquivar balas
		
		if (lastDistance+100 > distance){
			lastDistance = distance;
			
			if (getGunHeat()<1){
				setTurnRadarLeft(getRadarTurnRemaining());
			}
		
		}
		//fin bloque Linear Targeting
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + (e.getVelocity() / (AIM_START + Math.pow(AIM_FACTOR, distance))) * Math.sin(e.getHeadingRadians() - absoluteBearing) ));
		/*if(*/setFireBullet(Math.min(2.49999,getEnergy() / FIRE_FACTOR));// != null){
				/*lastDistance = Double.POSITIVE_INFINITY;
			}*/
		energiaAnterior = e.getEnergy();
	}

	public void onHitWall(HitWallEvent e) {
		// Esto provoca un rebote con la pared
		turnLeft(e.getBearing());
		setAhead (200);
	}	
}
