package kvk.Movement;
import kvk.Bots.Bot;
import kvk.ExtendedRobot;
import kvk.Utils.BattleField;
import kvk.Utils.C;
import kvk.Utils.Fct;
import kvk.Utils.Manager;
import kvk.Utils.Point;
import robocode.*;

/**
 *  Classe de gestion des mouvements
 *
 * @author     Ssin.le.Terrible
 * @created    14 janvier 2004
 */
public class MoveNimrodStyle extends Manager {

	public MoveNimrodStyle(ExtendedRobot er) {
		super(er);
	}

	public void action() {
		Bot      target;
		double   disAngle;
		double   minDisAngle;
		double   moveDistance;
		double   moveAngle;
		double   turnAngle;
		Point    myPosition       = myBot.getCoord();
		Point    nextPosition;
		Point    force;
		int      antiBlocCounter;                                                     //compteur pour viter de rester bloquer dans la boucle
		boolean  doWhile;

		target = myBot.getTarget();
		//S'il n'y a pas de cible, pas de mouvement
		if ((target == null) || !target.isUpdated()) {
			//myBot.print(true,"La cible n'est pas prte.");
			return;
		}

		if (Math.abs(myBot.getDistanceRemaining()) < Math.random() * 8 && myBot.getTime() > 8) {
			force = myBot.getBotManager().getNimrodForce();
			disAngle = C._PI4;
			moveDistance = target.getDistance() * 0.4d;
			minDisAngle = Math.max(C._PI6, Math.min(C._PI3, C._PI6 * (80 / moveDistance)));
			antiBlocCounter = 0;
			doWhile = true;
			do {
				moveAngle = Math.atan2(force.getX(), force.getY()) + Math.random() * 2 * disAngle - disAngle;
				nextPosition = Fct.calcXY(myPosition, moveAngle, 60 + moveDistance * Math.random());
				disAngle += 0.087266d;                                                      //(5d / 180d * C._PI);
				minDisAngle -= 0.087266d;                                                   //(5d / 180d * C._PI);
				antiBlocCounter++;
				doWhile = ((Math.abs(robocode.util.Utils.normalRelativeAngle(moveAngle - target.getAbsBearing() - C._PI)) < minDisAngle) || (!nextPosition.isOnSmallRoundedField()));
				if (antiBlocCounter > 50) {
					doWhile = false;
				}
			} while (doWhile);

			disAngle = robocode.util.Utils.normalRelativeAngle(Fct.bearing(myPosition, nextPosition) - myBot.getHeadingRadians());
			turnAngle = Math.atan(Math.tan(disAngle));
			myBot.setAhead((disAngle == turnAngle ? 1 : -1) * myPosition.distance(nextPosition));
			myBot.setTurnRightRadians(turnAngle);
		}
		myBot.setMaxVelocity(45d / myBot.getTurnRemaining());
		//myBot.setMaxVelocity(myBot.getTurnRemaining() > 30 ? 1d : (myBot.getTime() % 2 == 0 ? 8d : 7d));
	}

	public void reinitialise() {
	}
}

