package kvk.Movement;
import kvk.Bots.Bot;
import kvk.ExtendedRobot;
import kvk.Utils.BattleField;
import kvk.Utils.C;
import kvk.Utils.Fct;
import kvk.Utils.Manager;
import kvk.Utils.Point;
import robocode.*;

/**
 *  Classe de gestion des mouvements
 *
 * @author     Ssin.le.Terrible
 * @created    14 janvier 2004
 */
public class MoveRandomOvOStyle extends Manager {
	//{{{*** Variables
	private static  double  GOOD_DISTANCE;
	private         double  lateralAngle                   = 0.2d;
	private         double  timeBeforeChangeDirection      = 0d;
	private         double  distanceBeforeChangeDirection  = 0d;

	public MoveRandomOvOStyle(ExtendedRobot er) {
		super(er);
		GOOD_DISTANCE = Math.min(600d, Math.min(BattleField.getWidth(), BattleField.getHeight()) * 0.8d);
	}

	public void action() {
		Bot     target;
		double  targetDistance;
		double  moveAngle;
		double  turnAngle;
		double  tries           = 0d;
		double  distanceFactor  = 0d;                                                 //valeur entre -0.1 et +0.1 pour se rapprocher de GOOD_DISTANCE
		Point   myPosition      = myBot.getCoord();
		Point   nextPosition    = null;

		target = myBot.getTarget();
		//S'il n'y a pas de cible, pas de mouvement
		if ((target == null) || !target.isUpdated()) {
			//myBot.print(true,"La cible n'est pas prte.");
			return;
		}
		targetDistance = target.getDistance();

		//Changement de direction OLD
		//if (Math.random() < 0.05d) {
		//lateralAngle *= -1d;
		//}
		//Changement de direction OLD2
		//if (timeBeforeChangeDirection-- < 1) {
		//lateralAngle *= -1d;
		//timeBeforeChangeDirection = Math.max(target.getDistance(), GOOD_DISTANCE / 2d) / 13d * Math.max(Math.random(), 0.1d);
		//}
		//Changement de direction
		distanceBeforeChangeDirection -= Math.abs(myBot.getVelocity());
		if (distanceBeforeChangeDirection < 0) {
			lateralAngle *= (Math.random() > 0.29 ? -1d : 1d);
			distanceBeforeChangeDirection = Math.max(targetDistance, GOOD_DISTANCE / 2d) * 0.581717 * (Math.random() * 0.85d + 0.05d);
			//			1.059626 = tan(46.6)
			//			0.581717 = sin(36.0)
		}

		//gestion dynamique de la distance  la cible
		//distanceFactor = Fct.limite((GOOD_DISTANCE - target.getDistance()) / GOOD_DISTANCE, -1d, 1d) / 5d;
		distanceFactor = 0d;
		if (Math.abs(targetDistance - GOOD_DISTANCE) > 25d) {
			distanceFactor = (targetDistance < GOOD_DISTANCE ? 0.15d : -0.1d);
		}

		//Calcul de la destination
		do {
			nextPosition = Fct.calcXY(target.getCoord(), Fct.bearing(target.getCoord(), myPosition) + lateralAngle, targetDistance * (1 + distanceFactor - tries / 100d));
			tries++;
		} while (tries < 100 && !nextPosition.isOnSmallRoundedField());

		//Mouvement
		moveAngle = robocode.util.Utils.normalRelativeAngle(Fct.bearing(myPosition, nextPosition) - myBot.getHeadingRadians());
		turnAngle = Math.atan(Math.tan(moveAngle));
		myBot.setTurnRightRadians(turnAngle);
		myBot.setAhead(myPosition.distance(nextPosition) * (moveAngle == turnAngle ? 1 : -1));
		myBot.setMaxVelocity(7d + (Math.random() < 0.5 ? -1d : 1d) - (myBot.getTurnRemaining() > 45d ? 5d : 0d));
	}

	public void reinitialise() {
	}
}

